/**
 * 
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Gabriel Barbier (Mia-Software) - initial API and implementation
 * 
 * 
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.ModelFilterPropertiesPackage;
import org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.SelectedElement;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Selected Element</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.impl.SelectedElementImpl#getElementName <em>Element Name</em>}</li>
 *   <li>{@link org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.impl.SelectedElementImpl#getDependenciesLevel <em>Dependencies Level</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class SelectedElementImpl extends EObjectImpl implements SelectedElement {
	/**
	 * The default value of the '{@link #getElementName() <em>Element Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getElementName()
	 * @generated
	 * @ordered
	 */
	protected static final String ELEMENT_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getElementName() <em>Element Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getElementName()
	 * @generated
	 * @ordered
	 */
	protected String elementName = ELEMENT_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getDependenciesLevel() <em>Dependencies Level</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDependenciesLevel()
	 * @generated
	 * @ordered
	 */
	protected static final int DEPENDENCIES_LEVEL_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getDependenciesLevel() <em>Dependencies Level</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDependenciesLevel()
	 * @generated
	 * @ordered
	 */
	protected int dependenciesLevel = DEPENDENCIES_LEVEL_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SelectedElementImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ModelFilterPropertiesPackage.Literals.SELECTED_ELEMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getElementName() {
		return this.elementName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setElementName(String newElementName) {
		String oldElementName = this.elementName;
		this.elementName = newElementName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelFilterPropertiesPackage.SELECTED_ELEMENT__ELEMENT_NAME, oldElementName, this.elementName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getDependenciesLevel() {
		return this.dependenciesLevel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDependenciesLevel(int newDependenciesLevel) {
		int oldDependenciesLevel = this.dependenciesLevel;
		this.dependenciesLevel = newDependenciesLevel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ModelFilterPropertiesPackage.SELECTED_ELEMENT__DEPENDENCIES_LEVEL, oldDependenciesLevel, this.dependenciesLevel));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ModelFilterPropertiesPackage.SELECTED_ELEMENT__ELEMENT_NAME:
				return getElementName();
			case ModelFilterPropertiesPackage.SELECTED_ELEMENT__DEPENDENCIES_LEVEL:
				return new Integer(getDependenciesLevel());
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ModelFilterPropertiesPackage.SELECTED_ELEMENT__ELEMENT_NAME:
				setElementName((String)newValue);
				return;
			case ModelFilterPropertiesPackage.SELECTED_ELEMENT__DEPENDENCIES_LEVEL:
				setDependenciesLevel(((Integer)newValue).intValue());
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ModelFilterPropertiesPackage.SELECTED_ELEMENT__ELEMENT_NAME:
				setElementName(ELEMENT_NAME_EDEFAULT);
				return;
			case ModelFilterPropertiesPackage.SELECTED_ELEMENT__DEPENDENCIES_LEVEL:
				setDependenciesLevel(DEPENDENCIES_LEVEL_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ModelFilterPropertiesPackage.SELECTED_ELEMENT__ELEMENT_NAME:
				return ELEMENT_NAME_EDEFAULT == null ? this.elementName != null : !ELEMENT_NAME_EDEFAULT.equals(this.elementName);
			case ModelFilterPropertiesPackage.SELECTED_ELEMENT__DEPENDENCIES_LEVEL:
				return this.dependenciesLevel != DEPENDENCIES_LEVEL_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (elementName: ");
		result.append(this.elementName);
		result.append(", dependenciesLevel: ");
		result.append(this.dependenciesLevel);
		result.append(')');
		return result.toString();
	}

} //SelectedElementImpl
