/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecases.modelfilter.actions;

import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.discoverymanager.AbstractDiscovererImpl;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterDirectionKind;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameterImpl;
import org.eclipse.gmt.modisco.usecases.modelfilter.actions.Messages;
import org.eclipse.gmt.modisco.usecases.modelfilter.converter.JavaConverter;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverUmlModelWithDependenciesFromJavaFile
extends AbstractDiscovererImpl
implements Discoverer {
    private final DiscoveryParameterImpl recursionLevel = new DiscoveryParameterImpl("Recursion level", DiscoveryParameterDirectionKind.in, Integer.class, false);

    public boolean isApplicableTo(Object source) {
        boolean result = false;
        if (source instanceof ICompilationUnit) {
            result = true;
        }
        return result;
    }

    public String toString() {
        return "Discover UML model with extended dependencies from Java class";
    }

    public DiscoveryParameter getRecursionLevelParameter() {
        return this.recursionLevel;
    }

    public DiscoverUmlModelWithDependenciesFromJavaFile() {
        this.getBasicDiscovererParameters().add(this.recursionLevel);
    }

    public void discoverElement(Object source, final Map<DiscoveryParameter, Object> parameters) {
        ICompilationUnit javaFile = (ICompilationUnit)source;
        String elementName = javaFile.getPath().removeFileExtension().lastSegment();
        IJavaProject javaProject = javaFile.getJavaProject();
        if (!parameters.containsKey(this.getRecursionLevelParameter())) {
            final IInputValidator validator = new IInputValidator(){

                public String isValid(String newText) {
                    String result = null;
                    try {
                        int value = Integer.parseInt(newText);
                        if (value < 0) {
                            result = Messages.DiscoverUmlModelWithDependenciesFromJavaFile_positiveInteger;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        result = Messages.DiscoverUmlModelWithDependenciesFromJavaFile_recursionLevelAsAnInteger;
                    }
                    return result;
                }
            };
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    InputDialog dialog = new InputDialog(new Shell(), Messages.DiscoverUmlModelWithDependenciesFromJavaFile_recursionLevelTitle, Messages.DiscoverUmlModelWithDependenciesFromJavaFile_recursionLevelMessage, "1", validator);
                    if (dialog.open() == 0) {
                        int level = Integer.parseInt(dialog.getValue());
                        parameters.put(DiscoverUmlModelWithDependenciesFromJavaFile.this.getRecursionLevelParameter(), level);
                    } else {
                        parameters.put(DiscoverUmlModelWithDependenciesFromJavaFile.this.getRecursionLevelParameter(), 1);
                    }
                }
            });
        }
        int level = (Integer)parameters.get(this.getRecursionLevelParameter());
        JavaConverter converter = new JavaConverter(javaProject, javaFile);
        Resource result = converter.convertJavaProjectToUml2(elementName, level);
        parameters.put(this.getTargetModelParameter(), result);
    }
}

