/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecases.modelfilter.actions;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.infra.discoverymanager.AbstractDiscovererImpl;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.usecases.modelfilter.converter.RealTypesJavaConverter;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverUmlModelWithRealTypesFromJavaProject
extends AbstractDiscovererImpl
implements Discoverer {
    public boolean isApplicableTo(Object source) {
        boolean result = false;
        if (source instanceof IJavaProject) {
            result = true;
        } else if (source instanceof IProject) {
            IProject project = (IProject)source;
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    result = true;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String toString() {
        return "Discover MethodCalls model from Java operation";
    }

    public void discoverElement(Object source, Map<DiscoveryParameter, Object> parameters) {
        IJavaProject project;
        Resource result = null;
        IJavaProject tempProject = null;
        if (source instanceof IJavaProject) {
            tempProject = (IJavaProject)source;
        } else if (source instanceof IProject) {
            project = (IProject)source;
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    tempProject = JavaCore.create((IProject)project);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        project = tempProject;
        try {
            RealTypesJavaConverter discoverer = new RealTypesJavaConverter(project);
            result = discoverer.convertJavaProjectToUml2();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        parameters.put(this.getTargetModelParameter(), result);
    }
}

