/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecases.modelfilter.converter;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmt.modisco.common.core.logging.AtlLogHandler;
import org.eclipse.gmt.modisco.common.core.utils.ModelUtils;
import org.eclipse.gmt.modisco.common.core.utils.Tools;
import org.eclipse.gmt.modisco.java.actions.DiscoverJavaModelFromJavaProject;
import org.eclipse.gmt.modisco.kdm.uml2converter.KDMtoUML2Converter;
import org.eclipse.gmt.modisco.usecases.modelfilter.converter.WesternGecoConverter;
import org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.ModelFilterPropertiesFactory;
import org.eclipse.gmt.modisco.usecases.modelfilter.modelfilterproperties.SelectedElement;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.uml2.diagram.clazz.part.Messages;
import org.eclipse.uml2.diagram.clazz.part.UMLDiagramEditorPlugin;
import org.eclipse.uml2.uml.Model;

public class JavaConverter {
    private final ModelFilterPropertiesFactory factory = ModelFilterPropertiesFactory.eINSTANCE;
    private final Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private final IJavaProject javaProject;
    private final ICompilationUnit javaFile;
    private final IPath path;
    private final IPath j2se5ModelPath;
    private final URL kdmTransformation;
    private final URL umlTransformation;

    public JavaConverter(IJavaProject javaProjectParameter, ICompilationUnit javaFileParameter) {
        this.javaProject = javaProjectParameter;
        this.javaFile = javaFileParameter;
        this.path = this.javaFile.getPath().removeFileExtension();
        this.j2se5ModelPath = this.javaProject.getProject().getLocation().addTrailingSeparator().append(this.javaProject.getElementName()).addFileExtension("j2se5");
        this.kdmTransformation = this.getClass().getResource("transformations/J2se5FiltersToKdm.asm");
        this.umlTransformation = this.getClass().getResource("transformations/FiltersAtUml.asm");
    }

    public Resource convertJavaProjectToUml2(String elementName, int dependenciesLevel) {
        Resource result = null;
        SelectedElement selectedElement = this.factory.createSelectedElement();
        selectedElement.setElementName(elementName);
        selectedElement.setDependenciesLevel(dependenciesLevel);
        URI propertiesUri = URI.createPlatformResourceURI((String)this.path.addFileExtension("modelfilterproperties").toString(), (boolean)false);
        try {
            Tools.save((EObject)selectedElement, (URI)propertiesUri);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        AtlLogHandler logHandler = new AtlLogHandler(String.valueOf(this.javaProject.getProject().getLocation().addTrailingSeparator().toString()) + this.path.removeFirstSegments(1).addFileExtension("log").toString());
        this.logger.addHandler((Handler)logHandler);
        try {
            URI kdmModelUri = URI.createPlatformResourceURI((String)this.path.addFileExtension("kdm").toString(), (boolean)false);
            URI j2se5ModelUri = URI.createFileURI((String)this.j2se5ModelPath.toString());
            if (this.j2se5ModelPath.toFile().exists()) {
                try {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    resourceSet.getResource(j2se5ModelUri, true);
                }
                catch (Exception ioe) {
                    this.j2se5ModelPath.toFile().delete();
                }
            }
            if (!this.j2se5ModelPath.toFile().exists()) {
                DiscoverJavaModelFromJavaProject javaDiscoverer = new DiscoverJavaModelFromJavaProject();
                javaDiscoverer.discoverElement((Object)this.javaProject, j2se5ModelUri);
            }
            WesternGecoConverter wgConverter = new WesternGecoConverter();
            wgConverter.getKDMModelFromJ2SE5ModelWithCustomTransformation(j2se5ModelUri, propertiesUri, this.kdmTransformation, kdmModelUri);
            KDMtoUML2Converter converter = new KDMtoUML2Converter();
            URI outputURI = URI.createPlatformResourceURI((String)this.path.addFileExtension("uml").toString(), (boolean)false);
            converter.getUML2ModelFromKDMModelWithCustomTransformation(kdmModelUri, false, this.umlTransformation, outputURI);
            wgConverter.manageBidirectionalAssociations(outputURI);
            result = ModelUtils.load((URI)outputURI);
            URI diagramURI = URI.createPlatformResourceURI((String)this.path.addFileExtension("umlclass").toString(), (boolean)false);
            TransactionalEditingDomain editingDomain = WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain();
            ResourceSet resourceSet = editingDomain.getResourceSet();
            Resource modelResource = resourceSet.getResource(outputURI, true);
            EObject rootObject = (EObject)modelResource.getContents().get(0);
            for (EObject eObject : rootObject.eContents()) {
                if (!(eObject instanceof Model) || !((Model)eObject).getName().equals(this.javaProject.getElementName())) continue;
                rootObject = eObject;
            }
            final EObject diagramRoot = rootObject;
            final Resource diagramResource = editingDomain.getResourceSet().createResource(diagramURI);
            final String diagramName = diagramURI.lastSegment();
            final Diagram diagram = ViewService.createDiagram((EObject)diagramRoot, (String)"UMLClass", (PreferencesHint)UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            if (diagram != null) {
                AbstractTransactionalCommand command = new AbstractTransactionalCommand(editingDomain, Messages.UMLDiagramEditorUtil_CreateDiagramCommandLabel, Collections.EMPTY_LIST){

                    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                        diagramResource.getContents().add((Object)diagram);
                        diagram.setName(diagramName);
                        diagram.setElement(diagramRoot);
                        return CommandResult.newOKCommandResult();
                    }
                };
                IStatus status = OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)new NullProgressMonitor(), 1), null);
                if (status.isOK()) {
                    Tools.saveModel((Resource)diagramResource, (URI)diagramURI);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.removeHandler((Handler)logHandler);
        logHandler.close();
        try {
            this.javaFile.getParent().getCorrespondingResource().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            this.javaProject.getCorrespondingResource().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

