/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecases.modelfilter.converter;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmt.modisco.common.core.utils.ModelUtils;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.java.actions.DefaultDiscoverer;
import org.eclipse.gmt.modisco.java.actions.DiscoverJavaModelFromJavaProject;
import org.eclipse.gmt.modisco.java.actions.DiscoverKdmModelFromJavaProject;
import org.eclipse.gmt.modisco.kdm.uml2converter.KDMtoUML2Converter;
import org.eclipse.gmt.modisco.usecases.modelfilter.converter.WesternGecoConverter;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2m.atl.core.ATLCoreException;

public class MethodCallsJavaConverter {
    private final IJavaProject javaProject;
    private final IPath path;
    private URL umlTransformation;

    private URL getUmlTransformation() {
        if (this.umlTransformation == null) {
            this.umlTransformation = this.getClass().getResource("transformations/KDMtoUMLwithMethodCall.asm");
        }
        return this.umlTransformation;
    }

    public MethodCallsJavaConverter(IJavaProject javaProjectParameter) throws JavaModelException {
        this.javaProject = javaProjectParameter;
        this.path = this.javaProject.getCorrespondingResource().getLocation().addTrailingSeparator().append(this.javaProject.getElementName());
    }

    public Resource convertJavaProjectToJavaModel() {
        Resource result = null;
        IPath javaModelPath = this.path.addFileExtension("javaxmi");
        URI javaModelUri = URI.createFileURI((String)javaModelPath.toString());
        if (javaModelPath.toFile().exists()) {
            try {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                result = resourceSet.getResource(javaModelUri, true);
            }
            catch (Exception ioe) {
                javaModelPath.toFile().delete();
            }
        }
        if (!javaModelPath.toFile().exists()) {
            DiscoverJavaModelFromJavaProject javaDiscoverer = new DiscoverJavaModelFromJavaProject();
            HashMap<DiscoveryParameter, Boolean> parameters = new HashMap<DiscoveryParameter, Boolean>();
            parameters.put(DefaultDiscoverer.PARAMETER_SILENT_MODE, true);
            javaDiscoverer.discoverElement((Object)this.javaProject, parameters);
            result = (Resource)parameters.get(DefaultDiscoverer.PARAMETER_TARGET_RESOURCE);
        }
        return result;
    }

    public Resource convertJavaProjectToUml2() throws JavaModelException, ATLCoreException, IOException {
        Resource result = null;
        IPath kdmModelPath = this.path.addFileExtension("kdm");
        IPath umlModelPath = this.javaProject.getCorrespondingResource().getLocation().addTrailingSeparator().append(String.valueOf(this.javaProject.getElementName()) + "MethodCalls").addFileExtension("uml");
        URI kdmModelUri = URI.createFileURI((String)kdmModelPath.toString());
        if (kdmModelPath.toFile().exists()) {
            try {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                resourceSet.getResource(kdmModelUri, true);
            }
            catch (Exception ioe) {
                kdmModelPath.toFile().delete();
            }
        }
        boolean forceUmlTransformation = false;
        if (!kdmModelPath.toFile().exists()) {
            forceUmlTransformation = true;
            DiscoverKdmModelFromJavaProject javaDiscoverer = new DiscoverKdmModelFromJavaProject();
            javaDiscoverer.discoverElement((Object)this.javaProject, kdmModelUri);
        }
        KDMtoUML2Converter converter = new KDMtoUML2Converter();
        URI outputURI = URI.createFileURI((String)URI.decode((String)umlModelPath.toString()));
        boolean bl = forceUmlTransformation = forceUmlTransformation || !umlModelPath.toFile().exists();
        if (forceUmlTransformation) {
            converter.getUML2ModelFromKDMModelWithCustomTransformation(kdmModelUri, false, this.getUmlTransformation(), outputURI);
            WesternGecoConverter wgConverter = new WesternGecoConverter();
            wgConverter.manageBidirectionalAssociations(outputURI);
        }
        try {
            this.javaProject.getCorrespondingResource().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {
            // empty catch block
        }
        result = ModelUtils.load((URI)outputURI);
        return result;
    }
}

