/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecases.modelfilter.converter;

import java.net.URL;
import java.util.logging.Handler;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmt.modisco.common.core.logging.AtlLogHandler;
import org.eclipse.gmt.modisco.common.core.utils.ModelUtils;
import org.eclipse.gmt.modisco.java.actions.DiscoverKdmModelFromJavaProject;
import org.eclipse.gmt.modisco.kdm.uml2converter.KDMtoUML2Converter;
import org.eclipse.gmt.modisco.usecases.modelfilter.converter.WesternGecoConverter;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public class RealTypesJavaConverter {
    private final Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private final IJavaProject javaProject;
    private final IPath path;
    private final URL umlTransformation;

    public RealTypesJavaConverter(IJavaProject javaProjectParameter) throws JavaModelException {
        this.javaProject = javaProjectParameter;
        this.path = this.javaProject.getCorrespondingResource().getLocation().addTrailingSeparator().append(this.javaProject.getElementName());
        this.umlTransformation = this.getClass().getResource("transformations/RealTypeUML.asm");
    }

    public Resource convertJavaProjectToUml2() throws JavaModelException {
        Resource result = null;
        IPath logPath = this.path.addFileExtension("log");
        IPath kdmModelPath = this.path.addFileExtension("kdm");
        IPath umlModelPath = this.javaProject.getCorrespondingResource().getLocation().addTrailingSeparator().append(String.valueOf(this.javaProject.getElementName()) + "RealTypes").addFileExtension("uml");
        AtlLogHandler logHandler = new AtlLogHandler(logPath.toString());
        this.logger.addHandler((Handler)logHandler);
        try {
            URI kdmModelUri = URI.createFileURI((String)kdmModelPath.toString());
            if (kdmModelPath.toFile().exists()) {
                try {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    resourceSet.getResource(kdmModelUri, true);
                }
                catch (Exception ioe) {
                    kdmModelPath.toFile().delete();
                }
            }
            boolean forceUmlTransformation = false;
            if (!kdmModelPath.toFile().exists()) {
                forceUmlTransformation = true;
                DiscoverKdmModelFromJavaProject javaDiscoverer = new DiscoverKdmModelFromJavaProject();
                javaDiscoverer.discoverElement((Object)this.javaProject, kdmModelUri);
            }
            KDMtoUML2Converter converter = new KDMtoUML2Converter();
            URI outputURI = URI.createFileURI((String)URI.decode((String)umlModelPath.toString()));
            boolean bl = forceUmlTransformation = forceUmlTransformation || !umlModelPath.toFile().exists();
            if (forceUmlTransformation) {
                converter.getUML2ModelFromKDMModelWithCustomTransformation(kdmModelUri, false, this.umlTransformation, outputURI);
                WesternGecoConverter wgConverter = new WesternGecoConverter();
                wgConverter.manageBidirectionalAssociations(outputURI);
            }
            result = ModelUtils.load((URI)outputURI);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.logger.removeHandler((Handler)logHandler);
        logHandler.close();
        try {
            this.javaProject.getCorrespondingResource().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }
}

