/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.usecases.modelfilter.converter;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.common.core.utils.UriUtils;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IExtractor;
import org.eclipse.m2m.atl.core.IInjector;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.core.ModelFactory;
import org.eclipse.m2m.atl.core.launch.ILauncher;
import org.eclipse.m2m.atl.core.service.CoreService;
import org.eclipse.m2m.atl.core.ui.vm.asm.ASMModelWrapper;
import org.eclipse.m2m.atl.drivers.emf4atl.ASMEMFModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;

public class WesternGecoConverter {
    private final String kdmMMUri = "http://www.eclipse.org/MoDisco/kdm/action";
    private final String j2se5MMUri = "http://www.eclipse.org/MoDisco/J2SE5";
    private final String umlMMUri = "http://www.eclipse.org/uml2/2.1.0/UML";
    private final String csharpMMUri = "http://www.eclipse.org/MoDisco/CSharp";
    private final String propertiesMMUri = "http://www.eclipse.org/Modelplex/modelfilterproperties";

    public Resource getKDMModelFromJ2SE5ModelWithCustomTransformation(URI j2se5SourceModelUri, URI propertiesUri, final URL transformation, URI kdmTargetModelUri) throws IOException, ATLCoreException {
        ASMModelWrapper wrapper;
        ASMModel model;
        HashMap<String, String> modelHandlers = new HashMap<String, String>();
        String j2se5MetaModelName = "j2se5";
        modelHandlers.put(j2se5MetaModelName, "EMF");
        String kdmMetaModelName = "kdm";
        modelHandlers.put(kdmMetaModelName, "EMF");
        String propertiesMetaModelName = "Filter";
        modelHandlers.put(propertiesMetaModelName, "EMF");
        HashMap<String, HashMap<String, String>> launcherOptions = new HashMap<String, HashMap<String, String>>();
        launcherOptions.put("modelHandlers", modelHandlers);
        String launcherName = "Regular VM (with debugger)";
        final ILauncher launcher = CoreService.getLauncher((String)launcherName);
        launcher.initialize(launcherOptions);
        ModelFactory factory = CoreService.createModelFactory((String)launcher.getDefaultModelFactoryName());
        IInjector injector = CoreService.getInjector((String)factory.getDefaultInjectorName());
        IExtractor extractor = CoreService.getExtractor((String)factory.getDefaultExtractorName());
        HashMap referenceModelOptions = new HashMap();
        referenceModelOptions.put("modelHandlerName", modelHandlers.get(j2se5MetaModelName));
        referenceModelOptions.put("modelName", j2se5MetaModelName);
        referenceModelOptions.put("path", "http://www.eclipse.org/MoDisco/J2SE5");
        IReferenceModel j2se5MM = factory.newReferenceModel(referenceModelOptions);
        injector.inject((IModel)j2se5MM, "http://www.eclipse.org/MoDisco/J2SE5");
        HashMap<String, Object> modelOptions = new HashMap<String, Object>();
        String inModelName = "IN";
        modelOptions.put("modelName", inModelName);
        modelOptions.put("path", UriUtils.toString((URI)j2se5SourceModelUri));
        modelOptions.put("newModel", false);
        IModel input = factory.newModel(j2se5MM, modelOptions);
        injector.inject(input, UriUtils.toString((URI)j2se5SourceModelUri));
        launcher.addInModel(input, inModelName, j2se5MetaModelName);
        referenceModelOptions = new HashMap();
        referenceModelOptions.put("modelHandlerName", modelHandlers.get(propertiesMetaModelName));
        referenceModelOptions.put("modelName", propertiesMetaModelName);
        referenceModelOptions.put("path", "http://www.eclipse.org/Modelplex/modelfilterproperties");
        IReferenceModel propertiesMM = factory.newReferenceModel(referenceModelOptions);
        injector.inject((IModel)propertiesMM, "http://www.eclipse.org/Modelplex/modelfilterproperties");
        modelOptions = new HashMap();
        inModelName = "properties";
        modelOptions.put("modelName", inModelName);
        modelOptions.put("path", UriUtils.toString((URI)propertiesUri));
        modelOptions.put("newModel", false);
        IModel properties = factory.newModel(propertiesMM, modelOptions);
        injector.inject(properties, UriUtils.toString((URI)propertiesUri));
        launcher.addInModel(properties, inModelName, propertiesMetaModelName);
        referenceModelOptions = new HashMap();
        referenceModelOptions.put("modelHandlerName", modelHandlers.get(kdmMetaModelName));
        referenceModelOptions.put("modelName", kdmMetaModelName);
        referenceModelOptions.put("path", "http://www.eclipse.org/MoDisco/kdm/action");
        IReferenceModel kdmMM = factory.newReferenceModel(referenceModelOptions);
        injector.inject((IModel)kdmMM, "http://www.eclipse.org/MoDisco/kdm/action");
        modelOptions = new HashMap();
        inModelName = "OUT";
        modelOptions.put("modelName", inModelName);
        modelOptions.put("path", UriUtils.toString((URI)kdmTargetModelUri));
        modelOptions.put("newModel", true);
        IModel outputInstance = factory.newModel(kdmMM, modelOptions);
        launcher.addOutModel(outputInstance, inModelName, kdmMetaModelName);
        final HashMap<String, String> options = new HashMap<String, String>();
        options.put("continueAfterError", "true");
        options.put("printExecutionTime", "true");
        Job transformationThread = new Job("Convert J2SE5 model to KDM"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                try {
                    launcher.launch("run", monitor, options, new Object[]{transformation.openStream()});
                }
                catch (IOException e) {
                    result = Status.CANCEL_STATUS;
                    e.printStackTrace();
                }
                return result;
            }
        };
        transformationThread.schedule();
        try {
            transformationThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        extractor.extract(outputInstance, UriUtils.toString((URI)kdmTargetModelUri));
        Resource output = null;
        if (outputInstance instanceof ASMModelWrapper && (model = (wrapper = (ASMModelWrapper)outputInstance).getAsmModel()) instanceof ASMEMFModel) {
            output = ((ASMEMFModel)model).getExtent();
        }
        return output;
    }

    public Resource getKDMModelFromCSharpModelWithCustomTransformation(URI csharpSourceModelUri, URI propertiesUri, final URL transformation, URI kdmTargetModelUri) throws IOException, ATLCoreException {
        ASMModelWrapper wrapper;
        ASMModel model;
        HashMap<String, String> modelHandlers = new HashMap<String, String>();
        String csharpMetaModelName = "csharp";
        modelHandlers.put(csharpMetaModelName, "EMF");
        String kdmMetaModelName = "kdm";
        modelHandlers.put(kdmMetaModelName, "EMF");
        String propertiesMetaModelName = "Filter";
        modelHandlers.put(propertiesMetaModelName, "EMF");
        HashMap<String, HashMap<String, String>> launcherOptions = new HashMap<String, HashMap<String, String>>();
        launcherOptions.put("modelHandlers", modelHandlers);
        String launcherName = "Regular VM (with debugger)";
        final ILauncher launcher = CoreService.getLauncher((String)launcherName);
        launcher.initialize(launcherOptions);
        ModelFactory factory = CoreService.createModelFactory((String)launcher.getDefaultModelFactoryName());
        IInjector injector = CoreService.getInjector((String)factory.getDefaultInjectorName());
        IExtractor extractor = CoreService.getExtractor((String)factory.getDefaultExtractorName());
        HashMap referenceModelOptions = new HashMap();
        referenceModelOptions.put("modelHandlerName", modelHandlers.get(csharpMetaModelName));
        referenceModelOptions.put("modelName", csharpMetaModelName);
        referenceModelOptions.put("path", "http://www.eclipse.org/MoDisco/CSharp");
        IReferenceModel j2se5MM = factory.newReferenceModel(referenceModelOptions);
        injector.inject((IModel)j2se5MM, "http://www.eclipse.org/MoDisco/CSharp");
        HashMap<String, Object> modelOptions = new HashMap<String, Object>();
        String inModelName = "IN";
        modelOptions.put("modelName", inModelName);
        modelOptions.put("path", UriUtils.toString((URI)csharpSourceModelUri));
        modelOptions.put("newModel", false);
        IModel input = factory.newModel(j2se5MM, modelOptions);
        injector.inject(input, UriUtils.toString((URI)csharpSourceModelUri));
        launcher.addInModel(input, inModelName, csharpMetaModelName);
        referenceModelOptions = new HashMap();
        referenceModelOptions.put("modelHandlerName", modelHandlers.get(propertiesMetaModelName));
        referenceModelOptions.put("modelName", propertiesMetaModelName);
        referenceModelOptions.put("path", "http://www.eclipse.org/Modelplex/modelfilterproperties");
        IReferenceModel propertiesMM = factory.newReferenceModel(referenceModelOptions);
        injector.inject((IModel)propertiesMM, "http://www.eclipse.org/Modelplex/modelfilterproperties");
        modelOptions = new HashMap();
        inModelName = "properties";
        modelOptions.put("modelName", inModelName);
        modelOptions.put("path", UriUtils.toString((URI)propertiesUri));
        modelOptions.put("newModel", false);
        IModel properties = factory.newModel(propertiesMM, modelOptions);
        injector.inject(properties, UriUtils.toString((URI)propertiesUri));
        launcher.addInModel(properties, inModelName, propertiesMetaModelName);
        referenceModelOptions = new HashMap();
        referenceModelOptions.put("modelHandlerName", modelHandlers.get(kdmMetaModelName));
        referenceModelOptions.put("modelName", kdmMetaModelName);
        referenceModelOptions.put("path", "http://www.eclipse.org/MoDisco/kdm/action");
        IReferenceModel kdmMM = factory.newReferenceModel(referenceModelOptions);
        injector.inject((IModel)kdmMM, "http://www.eclipse.org/MoDisco/kdm/action");
        modelOptions = new HashMap();
        inModelName = "OUT";
        modelOptions.put("modelName", inModelName);
        modelOptions.put("path", UriUtils.toString((URI)kdmTargetModelUri));
        modelOptions.put("newModel", true);
        IModel outputInstance = factory.newModel(kdmMM, modelOptions);
        launcher.addOutModel(outputInstance, inModelName, kdmMetaModelName);
        final HashMap<String, String> options = new HashMap<String, String>();
        options.put("continueAfterError", "true");
        options.put("printExecutionTime", "true");
        Job transformationThread = new Job("Convert CSharp model to KDM"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                try {
                    launcher.launch("run", monitor, options, new Object[]{transformation.openStream()});
                }
                catch (IOException e) {
                    result = Status.CANCEL_STATUS;
                    e.printStackTrace();
                }
                return result;
            }
        };
        transformationThread.schedule();
        try {
            transformationThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        extractor.extract(outputInstance, UriUtils.toString((URI)kdmTargetModelUri));
        Resource output = null;
        if (outputInstance instanceof ASMModelWrapper && (model = (wrapper = (ASMModelWrapper)outputInstance).getAsmModel()) instanceof ASMEMFModel) {
            output = ((ASMEMFModel)model).getExtent();
        }
        return output;
    }

    public void manageBidirectionalAssociations(URI umlSourceUri) throws ATLCoreException {
        final URL transformation = this.getClass().getResource("transformations/UML2Copy.asm");
        final URL superimposedTransformation = this.getClass().getResource("transformations/BidirectionalAssociation.asm");
        HashMap<String, String> modelHandlers = new HashMap<String, String>();
        String umlMetaModelName = "uml";
        modelHandlers.put(umlMetaModelName, "UML2");
        HashMap<String, HashMap<String, String>> launcherOptions = new HashMap<String, HashMap<String, String>>();
        launcherOptions.put("modelHandlers", modelHandlers);
        String launcherName = "Regular VM (with debugger)";
        final ILauncher launcher = CoreService.getLauncher((String)launcherName);
        launcher.initialize(launcherOptions);
        ModelFactory factory = CoreService.createModelFactory((String)launcher.getDefaultModelFactoryName());
        IInjector injector = CoreService.getInjector((String)factory.getDefaultInjectorName());
        IExtractor extractor = CoreService.getExtractor((String)factory.getDefaultExtractorName());
        HashMap referenceModelOptions = new HashMap();
        referenceModelOptions.put("modelHandlerName", modelHandlers.get(umlMetaModelName));
        referenceModelOptions.put("modelName", umlMetaModelName);
        referenceModelOptions.put("path", "http://www.eclipse.org/uml2/2.1.0/UML");
        IReferenceModel umlMM = factory.newReferenceModel(referenceModelOptions);
        injector.inject((IModel)umlMM, "http://www.eclipse.org/uml2/2.1.0/UML");
        HashMap<String, Object> modelOptions = new HashMap<String, Object>();
        String inModelName = "umlInput";
        modelOptions.put("modelName", inModelName);
        modelOptions.put("path", UriUtils.toString((URI)umlSourceUri));
        modelOptions.put("newModel", false);
        IModel input = factory.newModel(umlMM, modelOptions);
        injector.inject(input, UriUtils.toString((URI)umlSourceUri));
        launcher.addInModel(input, inModelName, umlMetaModelName);
        modelOptions = new HashMap();
        inModelName = "OUT";
        modelOptions.put("modelName", inModelName);
        modelOptions.put("path", UriUtils.toString((URI)umlSourceUri));
        modelOptions.put("newModel", true);
        IModel outputInstance = factory.newModel(umlMM, modelOptions);
        launcher.addOutModel(outputInstance, inModelName, umlMetaModelName);
        final HashMap<String, String> options = new HashMap<String, String>();
        options.put("continueAfterError", "true");
        options.put("printExecutionTime", "true");
        Job transformationThread = new Job("Additional transformation for Uml"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                try {
                    launcher.launch("run", monitor, options, new Object[]{transformation.openStream(), superimposedTransformation.openStream()});
                }
                catch (IOException e) {
                    result = Status.CANCEL_STATUS;
                    e.printStackTrace();
                }
                return result;
            }
        };
        transformationThread.schedule();
        try {
            transformationThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        extractor.extract(outputInstance, UriUtils.toString((URI)umlSourceUri));
    }
}

