/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 */

package org.eclipse.gmt.modisco.examples.modelplex;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.runtime.ModelQueryParameterValue;
import org.eclipse.gmt.modisco.java.BodyDeclaration;
import org.eclipse.gmt.modisco.java.ClassDeclaration;
import org.eclipse.gmt.modisco.java.FieldDeclaration;
import org.eclipse.gmt.modisco.java.Type;
import org.eclipse.gmt.modisco.java.VariableDeclarationFragment;

/**
 * @author Gabriel Barbier
 *
 */
public class GetUsedTypesInProperties implements IJavaModelQuery {

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery#evaluate(org.eclipse.emf.ecore.EObject, java.util.List)
	 */
	public Object evaluate(EObject context,
			List<ModelQueryParameterValue> parameterValues)
			throws ModelQueryExecutionException {
		if (!(context instanceof ClassDeclaration)) {
			throw new ModelQueryExecutionException("Wrong context type");
		}
		ClassDeclaration source = (ClassDeclaration) context;
		EList<Type> result = new BasicEList<Type>();
		for (Type subtype : this.getUsedTypesInProperties(source)) {
			result.add(subtype);
		}
		return result;
	}
	
	public final Set<Type> getUsedTypesInProperties(ClassDeclaration contextType) {
		Set<Type> result = new HashSet<Type>();
		for (BodyDeclaration bodyDeclaration : contextType.getBodyDeclarations()) {
			if (bodyDeclaration instanceof FieldDeclaration) {
				FieldDeclaration field = (FieldDeclaration) bodyDeclaration;
				for (VariableDeclarationFragment variable : field.getFragments()) {
					GetFilteredPotentialTypes filteredQuery = new GetFilteredPotentialTypes();
					GetAllPotentialTypes query = new GetAllPotentialTypes();
					// add systematically original type of variable
					result.add(query.getType(variable));
					// add potential sub types ?
					EList<Type> types = filteredQuery.getFilteredPotentialTypes(variable);
					result.addAll(types);
				}
			}
		}
		return result;
	}
	
}
