/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 */

package org.eclipse.gmt.modisco.examples.modelplex;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.runtime.ModelQueryParameterValue;
import org.eclipse.gmt.modisco.java.AbstractTypeDeclaration;
import org.eclipse.gmt.modisco.java.ClassDeclaration;
import org.eclipse.gmt.modisco.java.ParameterizedType;
import org.eclipse.gmt.modisco.java.Type;
import org.eclipse.gmt.modisco.java.TypeAccess;

/**
 * @author Gabriel Barbier
 *
 */
public class GetAllSubTypes implements IJavaModelQuery {

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery#evaluate(org.eclipse.emf.ecore.EObject, java.util.List)
	 */
	public Object evaluate(EObject context,
			List<ModelQueryParameterValue> parameterValues)
			throws ModelQueryExecutionException {
		if (!(context instanceof Type)) {
			throw new ModelQueryExecutionException("Wrong context type");
		}
		Type source = (Type) context;
		EList<Type> result = new BasicEList<Type>();
		for (Type subtype : this.getAllSubTypes(source)) {
			result.add(subtype);
		}
		return result;
	}
	
	final Set<Type> getAllSubTypes(Type contextType) {
		Set<Type> result = new HashSet<Type>();
		TreeIterator<EObject> content = contextType.eResource().getAllContents();
		while (content.hasNext()) {
			EObject eObject = content.next();
			if (eObject instanceof Type) {
				Type currentType = (Type) eObject;
				if (isSuperTypeOf(contextType, currentType)) {
					result.add(currentType);
					result.addAll(this.getAllSubTypes(currentType));
				}
			}
		}
		return result;
	}
	/**
	 * @param contextClass
	 * @return
	 */
	private final boolean isSuperTypeOf(Type parent,
			Type type) {
		boolean result = false;
		if (type instanceof ParameterizedType) {
			ParameterizedType parameterizedType = (ParameterizedType) type;
			result = this.isSuperTypeOf(parent, parameterizedType.getType().getType());
		} else if (type instanceof AbstractTypeDeclaration) {
			AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration) type;
			for (TypeAccess superTypeAccess : abstractTypeDeclaration.getSuperInterfaces()) {
				Type superType = superTypeAccess.getType();
				if ((superType == parent) || (this.isSuperTypeOf(parent, superType))) {
					result = true;
				}
			}
			if (result == false) {
				if (type instanceof ClassDeclaration) {
					ClassDeclaration classDeclaration = (ClassDeclaration) type;
					if (classDeclaration.getSuperClass() != null) {
						Type superType = classDeclaration.getSuperClass().getType();
						if ((superType == parent) || (this.isSuperTypeOf(parent, superType))) {
							result = true;
						}
					}
				}
			}
		} else {
			/*
			 * nothing to check ?
			 * It could be only ArrayType, PrimitiveType or TypeParameter
			 */
		}
		
		return result;
	}
}
