/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 */

package org.eclipse.gmt.modisco.examples.modelplex;

import java.util.List;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.runtime.ModelQueryParameterValue;
import org.eclipse.gmt.modisco.java.AbstractTypeDeclaration;
import org.eclipse.gmt.modisco.java.InterfaceDeclaration;
import org.eclipse.gmt.modisco.java.SingleVariableDeclaration;
import org.eclipse.gmt.modisco.java.Type;
import org.eclipse.gmt.modisco.java.VariableDeclaration;
import org.eclipse.gmt.modisco.java.VariableDeclarationFragment;

/**
 * @author Gabriel Barbier
 *
 */
public class GetAllPotentialTypes implements IJavaModelQuery {

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery#evaluate(org.eclipse.emf.ecore.EObject, java.util.List)
	 */
	public Object evaluate(EObject context,
			List<ModelQueryParameterValue> parameterValues)
			throws ModelQueryExecutionException {
		if (!(context instanceof VariableDeclaration)) {
			throw new ModelQueryExecutionException("Wrong context type");
		}
		VariableDeclaration source = (VariableDeclaration) context;
		return this.getAllPotentialTypes(source);
	}
	
	public final EList<Type> getAllPotentialTypes(VariableDeclaration source) {
		EList<Type> result = new BasicEList<Type>();
		Type sourceType = this.getType(source);
		if (sourceType != null) {
			GetAllSubTypes query = new GetAllSubTypes();
			for (Type subtype : query.getAllSubTypes(sourceType)) {
				if (subtype instanceof AbstractTypeDeclaration) {
					if ((subtype instanceof InterfaceDeclaration) == false) {
						result.add(subtype);
					}
				} else {
					result.add(subtype);
				}
			}
		}
		return result;
	}
	
	final Type getType(VariableDeclaration element) {
		Type result = null;
		if (element != null) {
			if (element instanceof SingleVariableDeclaration) {
				SingleVariableDeclaration variable = (SingleVariableDeclaration) element;
				result = variable.getType().getType();
			} else if (element instanceof VariableDeclarationFragment) {
				VariableDeclarationFragment variable = (VariableDeclarationFragment) element;
				result = variable.getVariablesContainer().getType().getType();
			} else {
				// it is an EnumConstantDeclaration -> no types
				result = (Type) element.eContainer();
			}
		}
		return result;
	}
	
}
