/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. 
 *
 * Contributors:
 *    Grgoire Dup (Mia-Software)
 *******************************************************************************/
package org.eclipse.gmt.modisco.examples.modelplex;

import java.util.List;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.infra.query.core.exception.ModelQueryExecutionException;
import org.eclipse.gmt.modisco.infra.query.core.java.IJavaModelQuery;
import org.eclipse.gmt.modisco.infra.query.runtime.ModelQueryParameterValue;
import org.eclipse.gmt.modisco.java.ASTNode;
import org.eclipse.gmt.modisco.java.NamedElement;
import org.eclipse.gmt.modisco.java.emf.util.JavaUtil;

public class GetQualifiedName implements IJavaModelQuery {

	public Object evaluate(final EObject context,
			final List<ModelQueryParameterValue> parameterValues)
			throws ModelQueryExecutionException {
		if (!(context instanceof NamedElement)) {
			throw new ModelQueryExecutionException("Unexpected context type: "
					+ context);
		}
		ASTNode astNode = (ASTNode) context;	
		
		return JavaUtil.getQualifiedName(astNode);
	}



}
