 /*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Hugo Bruneliere (INRIA) - initial API and implementation
 *    Sbastien Minguet (Mia-Software) - initial API and implementation
 *    Frdric Madiot (Mia-Software) - initial API and implementation
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.modelplex;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.common.core.utils.ModelUtils;
import org.eclipse.gmt.modisco.common.core.utils.Tools;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.java.actions.DefaultDiscoverer;
import org.eclipse.gmt.modisco.java.actions.DiscoverKdmModelFromJavaProject;
import org.eclipse.gmt.modisco.kdm.uml2converter.KDMtoUML2Converter;
import org.eclipse.gmt.modisco.kdm.uml2converter.KdmToUmlConverterInterface;
import org.eclipse.gmt.modisco.modelplex.controller.BidirectionalAssociationDiscoverer;
import org.eclipse.gmt.modisco.modelplex.controller.impl.BidirectionalAssociationDiscovererImpl;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2m.atl.core.ATLCoreException;

public class ModelplexKnowledgeDiscoveryFramework implements KnowledgeDiscoveryInterface {

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.KnowledgeDiscoveryInterface#getUML2ModelFromJavaSource(org.eclipse.jdt.core.IJavaProject, org.eclipse.emf.common.util.URI)
	 */
	public Resource getUML2ModelFromJavaSource(IJavaProject javaProject, URI umlTargetModelUri) throws ATLCoreException { 
		Resource result = null;
		DiscoverKdmModelFromJavaProject javaDiscoverer = new DiscoverKdmModelFromJavaProject();
		KdmToUmlConverterInterface uml2Converter = new KDMtoUML2Converter();
		try {
//			File existingFile;
//			IPath intermediateJavaFilePath =
//				javaProject.getCorrespondingResource().getLocation().addTrailingSeparator().append(javaProject.getElementName()).addFileExtension("kdm");
		
//			existingFile = intermediateJavaFilePath.toFile();
//			if (existingFile.exists()) {
//				existingFile.delete();
//			}
			
			String kdmModelPath = umlTargetModelUri.trimFileExtension().appendFileExtension("kdm").toFileString();
//			existingFile = new File(kdmModelPath);
//			if (existingFile.exists()) {
//				existingFile.delete();
//			}
			
//			String umlModelPath = umlTargetModelUri.toFileString();
//			existingFile = new File(umlModelPath);
//			if (existingFile.exists()) {
//				existingFile.delete();
//			}
			javaProject.getCorrespondingResource().refreshLocal(1, null);
			
			Map<DiscoveryParameter, Object> parameters = new HashMap<DiscoveryParameter, Object>();
			parameters.put(DefaultDiscoverer.PARAMETER_SILENT_MODE, true);
			parameters.put(DefaultDiscoverer.PARAMETER_BROWSE_RESULT, false);
			javaDiscoverer.discoverElement(javaProject, parameters);
			Resource kdmModel = (Resource) parameters
					.get(DefaultDiscoverer.PARAMETER_TARGET_RESOURCE);
//			Resource kdmModel = javaDiscoverer.discoverElement(javaProject, (URI) null);
			javaProject.getCorrespondingResource().refreshLocal(1, null);
			Tools.saveModel(kdmModel, kdmModelPath);
			javaProject.getCorrespondingResource().refreshLocal(1, null);
			
			Resource[] convertedModels = uml2Converter.getUML2ModelFromKDMModel(kdmModel, false, umlTargetModelUri);
//			System.out.println("vrification du modle UML obtenu : " + ((convertedModels != null) && (convertedModels.length>0)));
			if ((convertedModels != null) && (convertedModels.length>0)) {
				result = convertedModels[0];
			}
			javaProject.getCorrespondingResource().refreshLocal(1, null);
		} catch (IOException e) {
			e.printStackTrace();
		} catch (JavaModelException e) {
			e.printStackTrace();
		} catch (CoreException e) {
			e.printStackTrace();
		}
		return result; 
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.KnowledgeDiscoveryInterface#detectPatternsFromJavaSource(org.eclipse.jdt.core.IJavaProject, org.eclipse.emf.ecore.resource.Resource, org.eclipse.core.resources.IFile)
	 */
	public Resource detectPatternsFromJavaSource(IJavaProject javaProject, Resource patternModel, IFile patternDetectionRules) { 
		/*
		 * TODO Not implemented yet
		 */
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.KnowledgeDiscoveryInterface#detectPatternsFromCSharpSource(org.eclipse.core.resources.IFolder, org.eclipse.emf.ecore.resource.Resource, org.eclipse.core.resources.IFile)
	 */
	public Resource detectPatternsFromCSharpSource(IFolder csharpProject, Resource patternModel, IFile patternDetectionRules) { 
		/*
		 * TODO Not implemented yet
		 */
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.KnowledgeDiscoveryInterface#detectBidirectionalAssociationsInUmlModel(org.eclipse.core.resources.IFile, org.eclipse.emf.common.util.URI)
	 */
	public Resource detectBidirectionalAssociationsInUmlModel(
			IFile sourceModel, URI umlTargetModelUri) throws ATLCoreException {
		final BidirectionalAssociationDiscoverer discoverer = new BidirectionalAssociationDiscovererImpl();
		Resource result = null;
		URI umlSourceUri = URI.createPlatformResourceURI(sourceModel.getFullPath().toString(), false);
		URI umlTargetUri = null;
		if (umlTargetModelUri != null) {
			umlTargetUri = umlTargetModelUri;
		} else {
			umlTargetUri = umlSourceUri;
		}
		discoverer.discoverBidirectionalAssociations(umlSourceUri, umlTargetUri);
		try {
			result = ModelUtils.load(umlTargetUri);
		} catch (IOException e) {
			e.printStackTrace();
		}
		return result;
	}
	
}
