/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.modelplex.actions;

import java.util.Map;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gmt.modisco.infra.discoverymanager.AbstractDiscovererImpl;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.modelplex.ModelplexKnowledgeDiscoveryFrameworkPlugin;
import org.eclipse.gmt.modisco.modelplex.controller.ControllerServices;
import org.eclipse.gmt.modisco.modelplex.controller.impl.ControllerImpl;
import org.eclipse.gmt.modisco.modelplex.model.ModelReadWriteServices;
import org.eclipse.gmt.modisco.modelplex.model.impl.ModelImpl;
import org.eclipse.gmt.modisco.modelplex.ui.ModelplexWizard;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/**
 * @author Gabriel Barbier
 * 
 */
public class DiscoveryCustomizationToUmlModelFromJavaProject extends AbstractDiscovererImpl implements Discoverer {

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.gmt.modisco.infra.discoverymanager.DiscovererInterface#applyTo
	 * (java.lang.Object)
	 */
	public boolean isApplicableTo(final Object source) {
		boolean result = false;
		if (source instanceof IJavaProject) {
			result = true;
		} else if (source instanceof IProject) {
			IProject project = (IProject) source;
			try {
				if (project.hasNature(JavaCore.NATURE_ID)) {
					result = true;
				}
			} catch (CoreException e) {
				e.printStackTrace();
			}
		}
		return result;
	}

	public String toString() {
		return "Discover UML model from Java project";
	}

	public DiscoveryCustomizationToUmlModelFromJavaProject() {
		super();
	}

	public void discoverElement(final Object source,
			final Map<DiscoveryParameter, Object> parameters) {
		// retrieval of Java project
		IJavaProject tempProject = null;
		if (source instanceof IJavaProject) {
			tempProject = (IJavaProject) source;
		} else if (source instanceof IProject) {
			IProject project = (IProject) source;
			try {
				if (project.hasNature(JavaCore.NATURE_ID)) {
					tempProject = JavaCore.create(project);
				}
			} catch (CoreException e) {
				e.printStackTrace();
			}
		}
		final IJavaProject project = tempProject;
		
		final ModelReadWriteServices modelServices = new ModelImpl(project);
		final ControllerServices controller = new ControllerImpl(project, modelServices);
		
		// access UI resources so that we can obtain the current eclipse
		// workbench activePage
		Display.getDefault().asyncExec(new Runnable() {
			public void run() {
				// Create the wizard
				final ModelplexWizard wizard = new ModelplexWizard(controller);
				// initialize dialog icon and store old one
				Image oldImage = Window.getDefaultImage();
				Window.setDefaultImage(ModelplexKnowledgeDiscoveryFrameworkPlugin.getImageDescriptor("resources/images/NewEcore2Ecore.gif").createImage());
				// Create the wizard dialog
				WizardDialog dialog = new WizardDialog(
						new Shell(), wizard);
				// Open the wizard dialog
				dialog.open();
				// restore default icon
				Window.setDefaultImage(oldImage);
			}
		});
		
	}

}
