 /*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Hugo Bruneliere (INRIA) - initial API and implementation
 *    Sbastien Minguet (Mia-Software) - initial API and implementation
 *    Frdric Madiot (Mia-Software) - initial API and implementation
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.modelplex.controller.impl;

import org.eclipse.gmt.modisco.modelplex.controller.ControllerServices;
import org.eclipse.gmt.modisco.modelplex.controller.Converter;
import org.eclipse.gmt.modisco.modelplex.controller.TransformationExporter;
import org.eclipse.gmt.modisco.modelplex.model.ModelReadWriteServices;
import org.eclipse.gmt.modisco.modelplex.model.ModelServices;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.AtlTransformation;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexTransformation;
import org.eclipse.jdt.core.IJavaProject;

public class ControllerImpl implements ControllerServices {
	
	private final IJavaProject javaProject;
	private TransformationExporter transformationExporter;
	private Converter converter;
	private final ModelReadWriteServices modelServices;
	
	public ControllerImpl(IJavaProject javaProjectParameter, ModelReadWriteServices modelServicesParameter) {
		this.javaProject = javaProjectParameter;
		this.modelServices = modelServicesParameter;
	}

	public TransformationExporter getTransformationExporter() {
		if (this.transformationExporter == null) {
			this.transformationExporter = new TransformationExporterImpl(this.getModelServices());
		}
		return this.transformationExporter;
	}

	public Converter getConverter() {
		if (this.converter == null) {
			this.converter = new ConverterImpl(this.javaProject, this.modelServices);
		}
		return this.converter;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.controller.ControllerServices#getModelServices()
	 */
	public ModelServices getModelServices() {
		return this.modelServices;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.controller.ControllerServices#createAdditionalTransformation(java.lang.String, org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexTransformation)
	 */
	public void createAdditionalTransformation(
			String additionalTransformationPath,
			ModelplexTransformation modelplexTransformation) {
		this.modelServices.createAdditionalTransformation(additionalTransformationPath, modelplexTransformation);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.controller.ControllerServices#deleteAdditionalTransformation(org.eclipse.gmt.modisco.modelplex.model.modelplex.AtlTransformation, org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexTransformation)
	 */
	public void deleteAdditionalTransformation(
			AtlTransformation additionalTransformation,
			ModelplexTransformation modelplexTransformation) {
		this.modelServices.deleteAdditionalTransformation(additionalTransformation, modelplexTransformation);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.controller.ControllerServices#updateAdditionalTransformation(org.eclipse.gmt.modisco.modelplex.model.modelplex.AtlTransformation, org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexTransformation, boolean)
	 */
	public void updateAdditionalTransformation(
			AtlTransformation additionalTransformation,
			ModelplexTransformation modelplexTransformation, boolean selected) {
		additionalTransformation.setSelected(selected);
		this.modelServices.updateAdditionalTransformation(additionalTransformation, modelplexTransformation);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.controller.ControllerServices#updateAdditionalTransformation(org.eclipse.gmt.modisco.modelplex.model.modelplex.AtlTransformation, org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexTransformation, java.lang.String)
	 */
	public void updateAdditionalTransformation(
			AtlTransformation additionalTransformation,
			ModelplexTransformation modelplexTransformation,
			String transformationPath) {
		additionalTransformation.setTransformationPath(transformationPath);
		this.modelServices.updateAdditionalTransformation(additionalTransformation, modelplexTransformation);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.controller.ControllerServices#downAdditionalTransformation(org.eclipse.gmt.modisco.modelplex.model.modelplex.AtlTransformation, org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexTransformation)
	 */
	public void downAdditionalTransformation(
			AtlTransformation additionalTransformation,
			ModelplexTransformation modelplexTransformation) {
		int index = modelplexTransformation.getChainedTransformations().indexOf(additionalTransformation);
		if (index < (modelplexTransformation.getChainedTransformations().size() - 1)) {
			modelplexTransformation.getChainedTransformations().remove(additionalTransformation);
			modelplexTransformation.getChainedTransformations().add(index + 1, additionalTransformation);
			
			this.modelServices.updateModelplexTransformation(modelplexTransformation);
		} // else nothing to do
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.controller.ControllerServices#upAdditionalTransformation(org.eclipse.gmt.modisco.modelplex.model.modelplex.AtlTransformation, org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexTransformation)
	 */
	public void upAdditionalTransformation(
			AtlTransformation additionalTransformation,
			ModelplexTransformation modelplexTransformation) {
		int index = modelplexTransformation.getChainedTransformations().indexOf(additionalTransformation);
		if (index > 0) {
			modelplexTransformation.getChainedTransformations().remove(additionalTransformation);
			modelplexTransformation.getChainedTransformations().add(index - 1, additionalTransformation);
			
			this.modelServices.updateModelplexTransformation(modelplexTransformation);
		} // else nothing to do
	}

}
