 /*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Hugo Bruneliere (INRIA) - initial API and implementation
 *    Sbastien Minguet (Mia-Software) - initial API and implementation
 *    Frdric Madiot (Mia-Software) - initial API and implementation
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.modelplex.controller.impl;

import java.util.logging.Logger;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmt.modisco.common.core.logging.AtlLogHandler;
import org.eclipse.gmt.modisco.modelplex.ModelplexKnowledgeDiscoveryFramework;
import org.eclipse.gmt.modisco.modelplex.controller.CustomConverter;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class CustomConverterImpl implements CustomConverter {

	private final Logger logger = Logger.getLogger(ATLLogger.LOGGER_ID);
	private final IJavaProject javaProject;
	private IPath path;
	
	public CustomConverterImpl(IJavaProject javaProjectParameter) {
		this.javaProject = javaProjectParameter;
		try {
			if(this.javaProject != null) {
				IResource resource = this.javaProject.getCorrespondingResource();
				if(resource!=null)
					this.path = resource.getLocation().addTrailingSeparator().append(
							this.javaProject.getElementName()).addFileExtension("uml");
			}
		} catch (JavaModelException e) {
			e.printStackTrace();
		}
	}
	
	public void convertJavaProjectToUml2WithCustomTransformation(String customTransformationPath) {
//		try {
		Job job = new Job("Discovering UML2 model from Java project") {
			@Override
			protected IStatus run(IProgressMonitor monitor) {
				IStatus result = null;
				AtlLogHandler logHandler = new AtlLogHandler(CustomConverterImpl.this.path.toString() + ".log");
				CustomConverterImpl.this.logger.addHandler(logHandler);
				try {
					URI outputURI = URI.createFileURI(CustomConverterImpl.this.path.toString());
					ModelplexKnowledgeDiscoveryFramework discoverer = new ModelplexKnowledgeDiscoveryFramework();
//					Resource uml2Model =
						discoverer.getUML2ModelFromJavaSource(
								CustomConverterImpl.this.javaProject, outputURI);
										
					result = Status.OK_STATUS;
				}catch (Exception e) {
					result = Status.CANCEL_STATUS;
				} finally {
					CustomConverterImpl.this.logger.removeHandler(logHandler);
					logHandler.close();
					try {
						CustomConverterImpl.this.javaProject.getCorrespondingResource().refreshLocal(1, null);
					} catch (Exception e1) {
						//give up
					}	
				}
				return result;
			}
		};

		job.addJobChangeListener(new JobChangeAdapter() {
			public void done(IJobChangeEvent event) {
				Display.getDefault().asyncExec(new Runnable() {
					public void run() {
						try {
							IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
							IFile ifile = root.getFileForLocation(CustomConverterImpl.this.path);
							if (ifile.exists()) {
								IWorkbenchPage page = PlatformUI.getWorkbench()
								.getActiveWorkbenchWindow()
								.getActivePage();
								IDE.openEditor(page, ifile);
							}
						} catch (PartInitException e) {
							e.printStackTrace();
						}
					}
				});
			}
		});
		
		job.schedule();
//		} catch (MalformedURLException e2) {
//			System.err.println("Problem with transformation file " + customTransformationPath);
//		}
	}

}
