/*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Hugo Bruneliere (INRIA) - initial API and implementation
 *    Sbastien Minguet (Mia-Software) - initial API and implementation
 *    Frdric Madiot (Mia-Software) - initial API and implementation
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.modelplex.controller.impl;

import org.eclipse.core.runtime.IPath;
import org.eclipse.gmt.modisco.java.actions.TransformationsExporter;
import org.eclipse.gmt.modisco.kdm.uml2converter.KDMtoUML2Converter;
import org.eclipse.gmt.modisco.kdm.uml2converter.KdmToUmlConverterInterface;
import org.eclipse.gmt.modisco.modelplex.controller.TransformationExporter;
import org.eclipse.gmt.modisco.modelplex.model.ModelServices;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.DiscovererKind;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;

public class TransformationExporterImpl implements TransformationExporter {

	private final ModelServices modelServices;
	
	TransformationExporterImpl(ModelServices modelServicesParameter) {
		this.modelServices = modelServicesParameter;
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * org.eclipse.gmt.modisco.converter.kdm2uml2.controller.TransformationExporter
	 * #exportKdmToUml2Transformation()
	 */
	public void exportKdmToUmlTransformation() {
		
		SaveAsDialog dialog = new SaveAsDialog(PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getShell());
		dialog.setTitle("Export transformation Kdm to Uml");
		// dialog.setMessage("Select destination file in an ATL project.");
		dialog.open();
		IPath path = dialog.getResult();
		if (path.getFileExtension() == null
				|| !path.getFileExtension().equals("atl")) {
			path = path.addFileExtension("atl");
		}
		String asmPath = path.removeFileExtension().addFileExtension("asm").makeAbsolute().toString();
		this.modelServices.getDiscoverer().getToUml().setCustom(true);
		this.modelServices.getDiscoverer().getToUml().setTransformationPath(asmPath);
		
		KdmToUmlConverterInterface converter = new KDMtoUML2Converter();
		converter.exportKdmToUmlTransformation(path);
	}
	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.controller.TransformationExporter#exportSpecificToKdmTransformation()
	 */
	public void exportSpecificToKdmTransformation() {
		SaveAsDialog dialog = new SaveAsDialog(PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getShell());
		dialog.setTitle("Export specific transformation to Kdm");
		// dialog.setMessage("Select destination file in an ATL project.");
		dialog.open();
		IPath path = dialog.getResult();
		if (path.getFileExtension() == null
				|| !path.getFileExtension().equals("atl")) {
			path = path.addFileExtension("atl");
		}
		String asmPath = path.removeFileExtension().addFileExtension("asm").makeAbsolute().toString();
		this.modelServices.getDiscoverer().getToKdm().setCustom(true);
		this.modelServices.getDiscoverer().getToKdm().setTransformationPath(asmPath);
		
		if (this.modelServices.getDiscoverer().getKind() == DiscovererKind.JAVA) {
			TransformationsExporter converter = new TransformationsExporter();
			converter.exportJavaToKdmTransformation(path);
		}
	}
}
