/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.modelplex.model.impl;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.gmt.modisco.modelplex.model.ModelEvents;
import org.eclipse.gmt.modisco.modelplex.model.ModelEventsSubscribe;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.AtlTransformation;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexTransformation;

/**
 * @author Gabriel Barbier
 *
 */
public class ModelEventsDelegate implements ModelEvents, ModelEventsSubscribe {

	private final List<ModelEvents> modelEventsList = new ArrayList<ModelEvents>();
	
	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.model.ModelEvents#chainedTransformationAdded(org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexTransformation)
	 */
	public void chainedTransformationAdded(
			ModelplexTransformation modelplexTransformation, AtlTransformation additionalTransformation) {
		for (ModelEvents modelEvents : this.modelEventsList) {
			modelEvents.chainedTransformationAdded(modelplexTransformation, additionalTransformation);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.model.ModelEventsSubscribe#subscribe(org.eclipse.gmt.modisco.modelplex.model.ModelEvents)
	 */
	public void subscribe(ModelEvents modelEvents) {
		this.modelEventsList.add(modelEvents);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.model.ModelEventsSubscribe#unsubscribe(org.eclipse.gmt.modisco.modelplex.model.ModelEvents)
	 */
	public void unsubscribe(ModelEvents modelEvents) {
		this.modelEventsList.remove(modelEvents);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.model.ModelEvents#chainedTransformationRemoved(org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexTransformation, org.eclipse.gmt.modisco.modelplex.model.modelplex.AtlTransformation)
	 */
	public void chainedTransformationRemoved(
			ModelplexTransformation modelplexTransformation,
			AtlTransformation removedTransformation) {
		for (ModelEvents modelEvents : this.modelEventsList) {
			modelEvents.chainedTransformationRemoved(modelplexTransformation, removedTransformation);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.model.ModelEvents#chainedTransformationUpdated(org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexTransformation, org.eclipse.gmt.modisco.modelplex.model.modelplex.AtlTransformation)
	 */
	public void chainedTransformationUpdated(
			ModelplexTransformation modelplexTransformation,
			AtlTransformation updatedTransformation) {
		for (ModelEvents modelEvents : this.modelEventsList) {
			modelEvents.chainedTransformationUpdated(modelplexTransformation, updatedTransformation);
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.model.ModelEvents#modelplexTransformationUpdated(org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexTransformation)
	 */
	public void modelplexTransformationUpdated(
			ModelplexTransformation modelplexTransformation) {
		for (ModelEvents modelEvents : this.modelEventsList) {
			modelEvents.modelplexTransformationUpdated(modelplexTransformation);
		}
	}

}
