/*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.modelplex.model.impl;

import java.io.IOException;

import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmt.modisco.common.core.utils.Tools;
import org.eclipse.gmt.modisco.modelplex.model.ModelEventsSubscribe;
import org.eclipse.gmt.modisco.modelplex.model.ModelReadWriteServices;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.AtlTransformation;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.DiscovererKind;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexDiscoverer;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexFactory;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexTransformation;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

/**
 * @author Gabriel Barbier
 *
 */
public class ModelImpl implements ModelReadWriteServices {

	private final ModelplexFactory factory = ModelplexFactory.eINSTANCE;
	private String discovererPath;
	private ModelplexDiscoverer discoverer;
	private final ModelEventsDelegate delegate = new ModelEventsDelegate();
	
	/**
	 * @param javaProject
	 */
	public ModelImpl(IJavaProject javaProject) {
		/*
		 * Avant d'initialiser le discoverer, nous allons vrifier
		 * l'existence d'un fichier de proprits modelplex.
		 */
		try {
			IPath path = javaProject.getCorrespondingResource().getLocation().addTrailingSeparator().append(javaProject.getElementName()).addFileExtension("modelplex");
			this.discovererPath = path.toString();
			if (path.toFile().exists()) {
				Resource modelplexModel = new XMIResourceImpl();
				modelplexModel.setURI(URI.createFileURI(this.discovererPath));
				try {
					modelplexModel.load(null);
					for (EObject eObject : modelplexModel.getContents()) {
						if (eObject instanceof ModelplexDiscoverer) {
							this.discoverer = (ModelplexDiscoverer) eObject;
						}
					}
				} catch (IOException e) {
					this.defaultInit(DiscovererKind.JAVA);
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			} else {
				this.defaultInit(DiscovererKind.JAVA);
			}
		} catch (JavaModelException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		
	}

	private final void defaultInit(DiscovererKind kind) {
		/*
		 * initialisation du discoverer :
		 * 1. le discoverer est toujours compos de deux transformations de bases :
		 * 		- d'un mta modle spcifique vers le mta modle KDM
		 * 		- du mta modle KDM vers le mta modle UML
		 * 
		 * 2. et nous connaissons le type du discoverer.
		 */
		this.discoverer = this.factory.createModelplexDiscoverer();
		this.discoverer.setKind(kind);
		this.discoverer.setToKdm(this.factory.createModelplexTransformation());
		this.discoverer.setToUml(this.factory.createModelplexTransformation());
	}
	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.model.ModelServices#getDiscoverer()
	 */
	public ModelplexDiscoverer getDiscoverer() {
		return this.discoverer;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.model.ModelServices#persistDiscoverer()
	 */
	public void persistDiscoverer() {
		try {
			Tools.save(this.discoverer, this.discovererPath);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.model.ModelReadWriteServices#createAdditionalTransformation(java.lang.String, org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexTransformation)
	 */
	public void createAdditionalTransformation(
			String additionalTransformationPath,
			ModelplexTransformation modelplexTransformation) {
		AtlTransformation additionalTransformation = this.factory.createAtlTransformation();
		additionalTransformation.setSelected(true);
		additionalTransformation.setTransformationPath(additionalTransformationPath);
		modelplexTransformation.getChainedTransformations().add(additionalTransformation);
		this.delegate.chainedTransformationAdded(modelplexTransformation, additionalTransformation);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.model.ModelServices#getModelEventsSubscribe()
	 */
	public ModelEventsSubscribe getModelEventsSubscribe() {
		return this.delegate;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.model.ModelReadWriteServices#deleteAdditionalTransformation(org.eclipse.gmt.modisco.modelplex.model.modelplex.AtlTransformation, org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexTransformation)
	 */
	public void deleteAdditionalTransformation(
			AtlTransformation additionalTransformation,
			ModelplexTransformation modelplexTransformation) {
		additionalTransformation.setSelected(false);
		modelplexTransformation.getChainedTransformations().remove(additionalTransformation);
		this.delegate.chainedTransformationRemoved(modelplexTransformation, additionalTransformation);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.model.ModelReadWriteServices#updateAdditionalTransformation(org.eclipse.gmt.modisco.modelplex.model.modelplex.AtlTransformation, org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexTransformation)
	 */
	public void updateAdditionalTransformation(
			AtlTransformation additionalTransformation,
			ModelplexTransformation modelplexTransformation) {
		this.delegate.chainedTransformationUpdated(modelplexTransformation, additionalTransformation);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.gmt.modisco.modelplex.model.ModelReadWriteServices#updateModelplexTransformation(org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexTransformation)
	 */
	public void updateModelplexTransformation(
			ModelplexTransformation modelplexTransformation) {
		this.delegate.modelplexTransformationUpdated(modelplexTransformation);
	}
	
	
}
