/**
 * ******************************************************************************
 *  Copyright (c) 2009 Mia-Software.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 *  Contributors:
 *     Gabriel Barbier (Mia-Software) - initial API and implementation
 * ******************************************************************************
 *
 * $Id$
 */
package org.eclipse.gmt.modisco.modelplex.model.modelplex.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.AtlTransformation;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.DiscovererKind;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexDiscoverer;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexFactory;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexPackage;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexTransformation;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class ModelplexPackageImpl extends EPackageImpl implements ModelplexPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass modelplexDiscovererEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass modelplexTransformationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass atlTransformationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum discovererKindEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private ModelplexPackageImpl() {
		super(eNS_URI, ModelplexFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this model, and for any others upon which it depends.
	 * 
	 * <p>This method is used to initialize {@link ModelplexPackage#eINSTANCE} when that field is accessed.
	 * Clients should not invoke it directly. Instead, they should simply access that field to obtain the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static ModelplexPackage init() {
		if (isInited) return (ModelplexPackage)EPackage.Registry.INSTANCE.getEPackage(ModelplexPackage.eNS_URI);

		// Obtain or create and register package
		ModelplexPackageImpl theModelplexPackage = (ModelplexPackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof ModelplexPackageImpl ? EPackage.Registry.INSTANCE.get(eNS_URI) : new ModelplexPackageImpl());

		isInited = true;

		// Create package meta-data objects
		theModelplexPackage.createPackageContents();

		// Initialize created meta-data
		theModelplexPackage.initializePackageContents();

		// Mark meta-data to indicate it can't be changed
		theModelplexPackage.freeze();

  
		// Update the registry and return the package
		EPackage.Registry.INSTANCE.put(ModelplexPackage.eNS_URI, theModelplexPackage);
		return theModelplexPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getModelplexDiscoverer() {
		return modelplexDiscovererEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getModelplexDiscoverer_ToKdm() {
		return (EReference)modelplexDiscovererEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getModelplexDiscoverer_ToUml() {
		return (EReference)modelplexDiscovererEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getModelplexDiscoverer_Kind() {
		return (EAttribute)modelplexDiscovererEClass.getEStructuralFeatures().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getModelplexDiscoverer_Name() {
		return (EAttribute)modelplexDiscovererEClass.getEStructuralFeatures().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getModelplexTransformation() {
		return modelplexTransformationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getModelplexTransformation_Custom() {
		return (EAttribute)modelplexTransformationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getModelplexTransformation_ChainedTransformations() {
		return (EReference)modelplexTransformationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAtlTransformation() {
		return atlTransformationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAtlTransformation_TransformationPath() {
		return (EAttribute)atlTransformationEClass.getEStructuralFeatures().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAtlTransformation_Selected() {
		return (EAttribute)atlTransformationEClass.getEStructuralFeatures().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getDiscovererKind() {
		return discovererKindEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ModelplexFactory getModelplexFactory() {
		return (ModelplexFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents() {
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		modelplexDiscovererEClass = createEClass(MODELPLEX_DISCOVERER);
		createEReference(modelplexDiscovererEClass, MODELPLEX_DISCOVERER__TO_KDM);
		createEReference(modelplexDiscovererEClass, MODELPLEX_DISCOVERER__TO_UML);
		createEAttribute(modelplexDiscovererEClass, MODELPLEX_DISCOVERER__KIND);
		createEAttribute(modelplexDiscovererEClass, MODELPLEX_DISCOVERER__NAME);

		modelplexTransformationEClass = createEClass(MODELPLEX_TRANSFORMATION);
		createEAttribute(modelplexTransformationEClass, MODELPLEX_TRANSFORMATION__CUSTOM);
		createEReference(modelplexTransformationEClass, MODELPLEX_TRANSFORMATION__CHAINED_TRANSFORMATIONS);

		atlTransformationEClass = createEClass(ATL_TRANSFORMATION);
		createEAttribute(atlTransformationEClass, ATL_TRANSFORMATION__TRANSFORMATION_PATH);
		createEAttribute(atlTransformationEClass, ATL_TRANSFORMATION__SELECTED);

		// Create enums
		discovererKindEEnum = createEEnum(DISCOVERER_KIND);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents() {
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Create type parameters

		// Set bounds for type parameters

		// Add supertypes to classes
		modelplexTransformationEClass.getESuperTypes().add(this.getAtlTransformation());

		// Initialize classes and features; add operations and parameters
		initEClass(modelplexDiscovererEClass, ModelplexDiscoverer.class, "ModelplexDiscoverer", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEReference(getModelplexDiscoverer_ToKdm(), this.getModelplexTransformation(), null, "toKdm", null, 0, 1, ModelplexDiscoverer.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getModelplexDiscoverer_ToUml(), this.getModelplexTransformation(), null, "toUml", null, 0, 1, ModelplexDiscoverer.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getModelplexDiscoverer_Kind(), this.getDiscovererKind(), "kind", null, 0, 1, ModelplexDiscoverer.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getModelplexDiscoverer_Name(), ecorePackage.getEString(), "name", null, 0, 1, ModelplexDiscoverer.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(modelplexTransformationEClass, ModelplexTransformation.class, "ModelplexTransformation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getModelplexTransformation_Custom(), ecorePackage.getEBoolean(), "custom", null, 0, 1, ModelplexTransformation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEReference(getModelplexTransformation_ChainedTransformations(), this.getAtlTransformation(), null, "chainedTransformations", null, 0, -1, ModelplexTransformation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		initEClass(atlTransformationEClass, AtlTransformation.class, "AtlTransformation", !IS_ABSTRACT, !IS_INTERFACE, IS_GENERATED_INSTANCE_CLASS);
		initEAttribute(getAtlTransformation_TransformationPath(), ecorePackage.getEString(), "transformationPath", null, 0, 1, AtlTransformation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);
		initEAttribute(getAtlTransformation_Selected(), ecorePackage.getEBoolean(), "selected", null, 0, 1, AtlTransformation.class, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE, !IS_DERIVED, IS_ORDERED);

		// Initialize enums and add enum literals
		initEEnum(discovererKindEEnum, DiscovererKind.class, "DiscovererKind");
		addEEnumLiteral(discovererKindEEnum, DiscovererKind.CSHARP);
		addEEnumLiteral(discovererKindEEnum, DiscovererKind.JAVA);

		// Create resource
		createResource(eNS_URI);
	}

} //ModelplexPackageImpl
