 /*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Hugo Bruneliere (INRIA) - initial API and implementation
 *    Sbastien Minguet (Mia-Software) - initial API and implementation
 *    Frdric Madiot (Mia-Software) - initial API and implementation
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.modelplex.ui.data;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.gmt.modisco.modelplex.ModelplexKnowledgeDiscoveryFrameworkPlugin;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.AtlTransformation;
import org.eclipse.swt.graphics.Image;

/**
 * @author Gabriel Barbier
 *
 */
public class RelationshipPatternDisplay implements ElementDisplay {
	private final Image icone;
	private String name;
	private final AtlTransformation transformation;
	
	public RelationshipPatternDisplay(AtlTransformation transformationParameter) {
		this.transformation = transformationParameter;
		this.icone = ModelplexKnowledgeDiscoveryFrameworkPlugin.getImageDescriptor("resources/images/binding.gif").createImage();
		IPath path = new Path(this.transformation.getTransformationPath());
		this.name = path.lastSegment();
	}

	public Image getImage() {
		return this.icone;
	}

	public String getName() {
		return this.name;
	}
	
	public AtlTransformation getModelElement() {
		return this.transformation;
	}
	
	public void refresh() {
		IPath path = new Path(this.transformation.getTransformationPath());
		this.name = path.lastSegment();
	}
}
