 /*******************************************************************************
 * Copyright (c) 2008 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Hugo Bruneliere (INRIA) - initial API and implementation
 *    Sbastien Minguet (Mia-Software) - initial API and implementation
 *    Frdric Madiot (Mia-Software) - initial API and implementation
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 *******************************************************************************/

package org.eclipse.gmt.modisco.modelplex.ui.uml2bridge;

import org.eclipse.gmt.modisco.modelplex.ModelplexKnowledgeDiscoveryFrameworkPlugin;
import org.eclipse.gmt.modisco.modelplex.controller.ControllerServices;
import org.eclipse.gmt.modisco.modelplex.ui.common.PageValidationEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;

/**
 * @author Gabriel Barbier
 *
 */
public class Uml2BridgePage extends WizardPage implements PageValidationEvent {

	private Uml2BridgeBodyComposite wizardContent;
	private final ControllerServices controller;
	
	public Uml2BridgePage(ControllerServices controllerServices) {
		super("Uml2Bridge", "UML2 bridge", null);
		this.setDescription("A short description of conversion from KDM model to UML2 model.");
		this.setImageDescriptor(ModelplexKnowledgeDiscoveryFrameworkPlugin.getImageDescriptor("resources/images/NewEcore2EcoreBig.gif"));
		this.controller = controllerServices;
	}

	public void createControl(Composite parent) {
	      this.wizardContent = new Uml2BridgeBodyComposite(parent, SWT.NONE, this, this.controller);
	      
	      this.setControl(this.wizardContent);
	      
	      this.setPageComplete(this.wizardContent.validatePage());
	}

	public void pageValidationChanged(boolean validity) {
		this.setPageComplete(validity);
	}
}
