/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.modelplex;

import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmt.modisco.common.core.utils.ModelUtils;
import org.eclipse.gmt.modisco.common.core.utils.Tools;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.java.actions.DefaultDiscoverer;
import org.eclipse.gmt.modisco.java.actions.DiscoverKdmModelFromJavaProject;
import org.eclipse.gmt.modisco.kdm.uml2converter.KDMtoUML2Converter;
import org.eclipse.gmt.modisco.modelplex.KnowledgeDiscoveryInterface;
import org.eclipse.gmt.modisco.modelplex.controller.impl.BidirectionalAssociationDiscovererImpl;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.m2m.atl.core.ATLCoreException;

public class ModelplexKnowledgeDiscoveryFramework
implements KnowledgeDiscoveryInterface {
    public Resource getUML2ModelFromJavaSource(IJavaProject javaProject, URI umlTargetModelUri) throws ATLCoreException {
        Resource result = null;
        DiscoverKdmModelFromJavaProject javaDiscoverer = new DiscoverKdmModelFromJavaProject();
        KDMtoUML2Converter uml2Converter = new KDMtoUML2Converter();
        try {
            String kdmModelPath = umlTargetModelUri.trimFileExtension().appendFileExtension("kdm").toFileString();
            javaProject.getCorrespondingResource().refreshLocal(1, null);
            HashMap<DiscoveryParameter, Boolean> parameters = new HashMap<DiscoveryParameter, Boolean>();
            parameters.put(DefaultDiscoverer.PARAMETER_SILENT_MODE, true);
            parameters.put(DefaultDiscoverer.PARAMETER_BROWSE_RESULT, false);
            javaDiscoverer.discoverElement((Object)javaProject, parameters);
            Resource kdmModel = (Resource)parameters.get(DefaultDiscoverer.PARAMETER_TARGET_RESOURCE);
            javaProject.getCorrespondingResource().refreshLocal(1, null);
            Tools.saveModel((Resource)kdmModel, (String)kdmModelPath);
            javaProject.getCorrespondingResource().refreshLocal(1, null);
            Resource[] convertedModels = uml2Converter.getUML2ModelFromKDMModel(kdmModel, false, umlTargetModelUri);
            if (convertedModels != null && convertedModels.length > 0) {
                result = convertedModels[0];
            }
            javaProject.getCorrespondingResource().refreshLocal(1, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public Resource detectPatternsFromJavaSource(IJavaProject javaProject, Resource patternModel, IFile patternDetectionRules) {
        return null;
    }

    public Resource detectPatternsFromCSharpSource(IFolder csharpProject, Resource patternModel, IFile patternDetectionRules) {
        return null;
    }

    public Resource detectBidirectionalAssociationsInUmlModel(IFile sourceModel, URI umlTargetModelUri) throws ATLCoreException {
        BidirectionalAssociationDiscovererImpl discoverer = new BidirectionalAssociationDiscovererImpl();
        Resource result = null;
        URI umlSourceUri = URI.createPlatformResourceURI((String)sourceModel.getFullPath().toString(), (boolean)false);
        URI umlTargetUri = null;
        umlTargetUri = umlTargetModelUri != null ? umlTargetModelUri : umlSourceUri;
        discoverer.discoverBidirectionalAssociations(umlSourceUri, umlTargetUri);
        try {
            result = ModelUtils.load((URI)umlTargetUri);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }
}

