/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.modelplex.actions;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gmt.modisco.infra.discoverymanager.AbstractDiscovererImpl;
import org.eclipse.gmt.modisco.infra.discoverymanager.Discoverer;
import org.eclipse.gmt.modisco.infra.discoverymanager.DiscoveryParameter;
import org.eclipse.gmt.modisco.modelplex.ModelplexKnowledgeDiscoveryFrameworkPlugin;
import org.eclipse.gmt.modisco.modelplex.controller.impl.ControllerImpl;
import org.eclipse.gmt.modisco.modelplex.model.impl.ModelImpl;
import org.eclipse.gmt.modisco.modelplex.ui.ModelplexWizard;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.window.Window;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryCustomizationToUmlModelFromJavaProject
extends AbstractDiscovererImpl
implements Discoverer {
    public boolean isApplicableTo(Object source) {
        boolean result = false;
        if (source instanceof IJavaProject) {
            result = true;
        } else if (source instanceof IProject) {
            IProject project = (IProject)source;
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    result = true;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public String toString() {
        return "Discover UML model from Java project";
    }

    public void discoverElement(Object source, Map<DiscoveryParameter, Object> parameters) {
        IJavaProject project;
        IJavaProject tempProject = null;
        if (source instanceof IJavaProject) {
            tempProject = (IJavaProject)source;
        } else if (source instanceof IProject) {
            project = (IProject)source;
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    tempProject = JavaCore.create((IProject)project);
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        project = tempProject;
        ModelImpl modelServices = new ModelImpl(project);
        final ControllerImpl controller = new ControllerImpl(project, modelServices);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ModelplexWizard wizard = new ModelplexWizard(controller);
                Image oldImage = Window.getDefaultImage();
                Window.setDefaultImage((Image)ModelplexKnowledgeDiscoveryFrameworkPlugin.getImageDescriptor("resources/images/NewEcore2Ecore.gif").createImage());
                WizardDialog dialog = new WizardDialog(new Shell(), (IWizard)wizard);
                dialog.open();
                Window.setDefaultImage((Image)oldImage);
            }
        });
    }
}

