/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.modelplex.controller.impl;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmt.modisco.common.core.utils.UriUtils;
import org.eclipse.gmt.modisco.modelplex.controller.BidirectionalAssociationDiscoverer;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IExtractor;
import org.eclipse.m2m.atl.core.IInjector;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.core.ModelFactory;
import org.eclipse.m2m.atl.core.launch.ILauncher;
import org.eclipse.m2m.atl.core.service.CoreService;

public class BidirectionalAssociationDiscovererImpl
implements BidirectionalAssociationDiscoverer {
    private final String umlMMUri = "http://www.eclipse.org/uml2/2.1.0/UML";

    public void discoverBidirectionalAssociations(URI umlSourceUri, URI umlTargetUri) throws ATLCoreException {
        final URL transformation = this.getClass().getResource("transformations/UML2Copy.asm");
        final URL superimposedTransformation = this.getClass().getResource("transformations/BidirectionalAssociation.asm");
        HashMap<String, String> modelHandlers = new HashMap<String, String>();
        String umlMetaModelName = "uml";
        modelHandlers.put(umlMetaModelName, "UML2");
        HashMap<String, HashMap<String, String>> launcherOptions = new HashMap<String, HashMap<String, String>>();
        launcherOptions.put("modelHandlers", modelHandlers);
        String launcherName = "Regular VM (with debugger)";
        final ILauncher launcher = CoreService.getLauncher((String)launcherName);
        launcher.initialize(launcherOptions);
        ModelFactory factory = CoreService.createModelFactory((String)launcher.getDefaultModelFactoryName());
        IInjector injector = CoreService.getInjector((String)factory.getDefaultInjectorName());
        IExtractor extractor = CoreService.getExtractor((String)factory.getDefaultExtractorName());
        HashMap referenceModelOptions = new HashMap();
        referenceModelOptions.put("modelHandlerName", modelHandlers.get(umlMetaModelName));
        referenceModelOptions.put("modelName", umlMetaModelName);
        referenceModelOptions.put("path", "http://www.eclipse.org/uml2/2.1.0/UML");
        IReferenceModel umlMM = factory.newReferenceModel(referenceModelOptions);
        injector.inject((IModel)umlMM, "http://www.eclipse.org/uml2/2.1.0/UML");
        HashMap<String, Object> modelOptions = new HashMap<String, Object>();
        String inModelName = "umlInput";
        modelOptions.put("modelName", inModelName);
        modelOptions.put("path", UriUtils.toString((URI)umlSourceUri));
        modelOptions.put("newModel", false);
        IModel input = factory.newModel(umlMM, modelOptions);
        injector.inject(input, UriUtils.toString((URI)umlSourceUri));
        launcher.addInModel(input, inModelName, umlMetaModelName);
        modelOptions = new HashMap();
        inModelName = "OUT";
        modelOptions.put("modelName", inModelName);
        if (umlTargetUri == null) {
            modelOptions.put("path", UriUtils.toString((URI)umlSourceUri));
        } else {
            modelOptions.put("path", UriUtils.toString((URI)umlTargetUri));
        }
        modelOptions.put("newModel", true);
        IModel outputInstance = factory.newModel(umlMM, modelOptions);
        launcher.addOutModel(outputInstance, inModelName, umlMetaModelName);
        final HashMap<String, String> options = new HashMap<String, String>();
        options.put("continueAfterError", "true");
        options.put("printExecutionTime", "true");
        Job transformationThread = new Job("Bidirectional associations for Uml"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = Status.OK_STATUS;
                try {
                    launcher.launch("run", monitor, options, new Object[]{transformation.openStream(), superimposedTransformation.openStream()});
                }
                catch (IOException e) {
                    result = Status.CANCEL_STATUS;
                    e.printStackTrace();
                }
                return result;
            }
        };
        transformationThread.schedule();
        try {
            transformationThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (umlTargetUri == null) {
            extractor.extract(outputInstance, UriUtils.toString((URI)umlSourceUri));
        } else {
            extractor.extract(outputInstance, UriUtils.toString((URI)umlTargetUri));
        }
    }
}

