/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.modelplex.controller.impl;

import org.eclipse.gmt.modisco.modelplex.controller.ControllerServices;
import org.eclipse.gmt.modisco.modelplex.controller.Converter;
import org.eclipse.gmt.modisco.modelplex.controller.TransformationExporter;
import org.eclipse.gmt.modisco.modelplex.controller.impl.ConverterImpl;
import org.eclipse.gmt.modisco.modelplex.controller.impl.TransformationExporterImpl;
import org.eclipse.gmt.modisco.modelplex.model.ModelReadWriteServices;
import org.eclipse.gmt.modisco.modelplex.model.ModelServices;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.AtlTransformation;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexTransformation;
import org.eclipse.jdt.core.IJavaProject;

public class ControllerImpl
implements ControllerServices {
    private final IJavaProject javaProject;
    private TransformationExporter transformationExporter;
    private Converter converter;
    private final ModelReadWriteServices modelServices;

    public ControllerImpl(IJavaProject javaProjectParameter, ModelReadWriteServices modelServicesParameter) {
        this.javaProject = javaProjectParameter;
        this.modelServices = modelServicesParameter;
    }

    public TransformationExporter getTransformationExporter() {
        if (this.transformationExporter == null) {
            this.transformationExporter = new TransformationExporterImpl(this.getModelServices());
        }
        return this.transformationExporter;
    }

    public Converter getConverter() {
        if (this.converter == null) {
            this.converter = new ConverterImpl(this.javaProject, this.modelServices);
        }
        return this.converter;
    }

    public ModelServices getModelServices() {
        return this.modelServices;
    }

    public void createAdditionalTransformation(String additionalTransformationPath, ModelplexTransformation modelplexTransformation) {
        this.modelServices.createAdditionalTransformation(additionalTransformationPath, modelplexTransformation);
    }

    public void deleteAdditionalTransformation(AtlTransformation additionalTransformation, ModelplexTransformation modelplexTransformation) {
        this.modelServices.deleteAdditionalTransformation(additionalTransformation, modelplexTransformation);
    }

    public void updateAdditionalTransformation(AtlTransformation additionalTransformation, ModelplexTransformation modelplexTransformation, boolean selected) {
        additionalTransformation.setSelected(selected);
        this.modelServices.updateAdditionalTransformation(additionalTransformation, modelplexTransformation);
    }

    public void updateAdditionalTransformation(AtlTransformation additionalTransformation, ModelplexTransformation modelplexTransformation, String transformationPath) {
        additionalTransformation.setTransformationPath(transformationPath);
        this.modelServices.updateAdditionalTransformation(additionalTransformation, modelplexTransformation);
    }

    public void downAdditionalTransformation(AtlTransformation additionalTransformation, ModelplexTransformation modelplexTransformation) {
        int index = modelplexTransformation.getChainedTransformations().indexOf((Object)additionalTransformation);
        if (index < modelplexTransformation.getChainedTransformations().size() - 1) {
            modelplexTransformation.getChainedTransformations().remove((Object)additionalTransformation);
            modelplexTransformation.getChainedTransformations().add(index + 1, (Object)additionalTransformation);
            this.modelServices.updateModelplexTransformation(modelplexTransformation);
        }
    }

    public void upAdditionalTransformation(AtlTransformation additionalTransformation, ModelplexTransformation modelplexTransformation) {
        int index = modelplexTransformation.getChainedTransformations().indexOf((Object)additionalTransformation);
        if (index > 0) {
            modelplexTransformation.getChainedTransformations().remove((Object)additionalTransformation);
            modelplexTransformation.getChainedTransformations().add(index - 1, (Object)additionalTransformation);
            this.modelServices.updateModelplexTransformation(modelplexTransformation);
        }
    }
}

