/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.modelplex.controller.impl;

import java.util.logging.Handler;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmt.modisco.common.core.logging.AtlLogHandler;
import org.eclipse.gmt.modisco.modelplex.ModelplexKnowledgeDiscoveryFramework;
import org.eclipse.gmt.modisco.modelplex.controller.CustomConverter;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class CustomConverterImpl
implements CustomConverter {
    private final Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private final IJavaProject javaProject;
    private IPath path;

    public CustomConverterImpl(IJavaProject javaProjectParameter) {
        this.javaProject = javaProjectParameter;
        try {
            IResource resource;
            if (this.javaProject != null && (resource = this.javaProject.getCorrespondingResource()) != null) {
                this.path = resource.getLocation().addTrailingSeparator().append(this.javaProject.getElementName()).addFileExtension("uml");
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    public void convertJavaProjectToUml2WithCustomTransformation(String customTransformationPath) {
        Job job = new Job("Discovering UML2 model from Java project"){

            protected IStatus run(IProgressMonitor monitor) {
                IStatus result = null;
                AtlLogHandler logHandler = new AtlLogHandler(String.valueOf(CustomConverterImpl.this.path.toString()) + ".log");
                CustomConverterImpl.this.logger.addHandler((Handler)logHandler);
                try {
                    try {
                        URI outputURI = URI.createFileURI((String)CustomConverterImpl.this.path.toString());
                        ModelplexKnowledgeDiscoveryFramework discoverer = new ModelplexKnowledgeDiscoveryFramework();
                        discoverer.getUML2ModelFromJavaSource(CustomConverterImpl.this.javaProject, outputURI);
                        result = Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        result = Status.CANCEL_STATUS;
                        CustomConverterImpl.this.logger.removeHandler((Handler)logHandler);
                        logHandler.close();
                        try {
                            CustomConverterImpl.this.javaProject.getCorrespondingResource().refreshLocal(1, null);
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    CustomConverterImpl.this.logger.removeHandler((Handler)logHandler);
                    logHandler.close();
                    try {
                        CustomConverterImpl.this.javaProject.getCorrespondingResource().refreshLocal(1, null);
                    }
                    catch (Exception exception) {}
                }
                return result;
            }
        };
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        try {
                            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                            IFile ifile = root.getFileForLocation(CustomConverterImpl.this.path);
                            if (ifile.exists()) {
                                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                IDE.openEditor((IWorkbenchPage)page, (IFile)ifile);
                            }
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
        job.schedule();
    }
}

