/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.modelplex.controller.impl;

import org.eclipse.core.runtime.IPath;
import org.eclipse.gmt.modisco.java.actions.TransformationsExporter;
import org.eclipse.gmt.modisco.kdm.uml2converter.KDMtoUML2Converter;
import org.eclipse.gmt.modisco.modelplex.controller.TransformationExporter;
import org.eclipse.gmt.modisco.modelplex.model.ModelServices;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.DiscovererKind;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;

public class TransformationExporterImpl
implements TransformationExporter {
    private final ModelServices modelServices;

    TransformationExporterImpl(ModelServices modelServicesParameter) {
        this.modelServices = modelServicesParameter;
    }

    public void exportKdmToUmlTransformation() {
        SaveAsDialog dialog = new SaveAsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.setTitle("Export transformation Kdm to Uml");
        dialog.open();
        IPath path = dialog.getResult();
        if (path.getFileExtension() == null || !path.getFileExtension().equals("atl")) {
            path = path.addFileExtension("atl");
        }
        String asmPath = path.removeFileExtension().addFileExtension("asm").makeAbsolute().toString();
        this.modelServices.getDiscoverer().getToUml().setCustom(true);
        this.modelServices.getDiscoverer().getToUml().setTransformationPath(asmPath);
        KDMtoUML2Converter converter = new KDMtoUML2Converter();
        converter.exportKdmToUmlTransformation(path);
    }

    public void exportSpecificToKdmTransformation() {
        SaveAsDialog dialog = new SaveAsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.setTitle("Export specific transformation to Kdm");
        dialog.open();
        IPath path = dialog.getResult();
        if (path.getFileExtension() == null || !path.getFileExtension().equals("atl")) {
            path = path.addFileExtension("atl");
        }
        String asmPath = path.removeFileExtension().addFileExtension("asm").makeAbsolute().toString();
        this.modelServices.getDiscoverer().getToKdm().setCustom(true);
        this.modelServices.getDiscoverer().getToKdm().setTransformationPath(asmPath);
        if (this.modelServices.getDiscoverer().getKind() == DiscovererKind.JAVA) {
            TransformationsExporter converter = new TransformationsExporter();
            converter.exportJavaToKdmTransformation(path);
        }
    }
}

