/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.modelplex.model.impl;

import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.gmt.modisco.common.core.utils.Tools;
import org.eclipse.gmt.modisco.modelplex.model.ModelEventsSubscribe;
import org.eclipse.gmt.modisco.modelplex.model.ModelReadWriteServices;
import org.eclipse.gmt.modisco.modelplex.model.impl.ModelEventsDelegate;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.AtlTransformation;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.DiscovererKind;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexDiscoverer;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexFactory;
import org.eclipse.gmt.modisco.modelplex.model.modelplex.ModelplexTransformation;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

public class ModelImpl
implements ModelReadWriteServices {
    private final ModelplexFactory factory;
    private String discovererPath;
    private ModelplexDiscoverer discoverer;
    private final ModelEventsDelegate delegate;

    public ModelImpl(IJavaProject javaProject) {
        block6: {
            this.factory = ModelplexFactory.eINSTANCE;
            this.delegate = new ModelEventsDelegate();
            try {
                IPath path = javaProject.getCorrespondingResource().getLocation().addTrailingSeparator().append(javaProject.getElementName()).addFileExtension("modelplex");
                this.discovererPath = path.toString();
                if (path.toFile().exists()) {
                    XMIResourceImpl modelplexModel = new XMIResourceImpl();
                    modelplexModel.setURI(URI.createFileURI((String)this.discovererPath));
                    try {
                        modelplexModel.load(null);
                        for (EObject eObject : modelplexModel.getContents()) {
                            if (!(eObject instanceof ModelplexDiscoverer)) continue;
                            this.discoverer = (ModelplexDiscoverer)eObject;
                        }
                        break block6;
                    }
                    catch (IOException e) {
                        this.defaultInit(DiscovererKind.JAVA);
                        e.printStackTrace();
                    }
                    break block6;
                }
                this.defaultInit(DiscovererKind.JAVA);
            }
            catch (JavaModelException e1) {
                e1.printStackTrace();
            }
        }
    }

    private final void defaultInit(DiscovererKind kind) {
        this.discoverer = this.factory.createModelplexDiscoverer();
        this.discoverer.setKind(kind);
        this.discoverer.setToKdm(this.factory.createModelplexTransformation());
        this.discoverer.setToUml(this.factory.createModelplexTransformation());
    }

    public ModelplexDiscoverer getDiscoverer() {
        return this.discoverer;
    }

    public void persistDiscoverer() {
        try {
            Tools.save((EObject)this.discoverer, (String)this.discovererPath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createAdditionalTransformation(String additionalTransformationPath, ModelplexTransformation modelplexTransformation) {
        AtlTransformation additionalTransformation = this.factory.createAtlTransformation();
        additionalTransformation.setSelected(true);
        additionalTransformation.setTransformationPath(additionalTransformationPath);
        modelplexTransformation.getChainedTransformations().add((Object)additionalTransformation);
        this.delegate.chainedTransformationAdded(modelplexTransformation, additionalTransformation);
    }

    public ModelEventsSubscribe getModelEventsSubscribe() {
        return this.delegate;
    }

    public void deleteAdditionalTransformation(AtlTransformation additionalTransformation, ModelplexTransformation modelplexTransformation) {
        additionalTransformation.setSelected(false);
        modelplexTransformation.getChainedTransformations().remove((Object)additionalTransformation);
        this.delegate.chainedTransformationRemoved(modelplexTransformation, additionalTransformation);
    }

    public void updateAdditionalTransformation(AtlTransformation additionalTransformation, ModelplexTransformation modelplexTransformation) {
        this.delegate.chainedTransformationUpdated(modelplexTransformation, additionalTransformation);
    }

    public void updateModelplexTransformation(ModelplexTransformation modelplexTransformation) {
        this.delegate.modelplexTransformationUpdated(modelplexTransformation);
    }
}

