/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.driver.acceleo.ui;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.gmt.modisco.workflow.AbstractDriverCore;
import org.eclipse.gmt.modisco.workflow.DriverInterface;
import org.eclipse.gmt.modisco.workflow.driver.acceleo.Constant;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Direction;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameter;

public class LaunchDriverAcceleo extends AbstractDriverCore implements DriverInterface {
	
	public String getTypeLaunchConfig() {
		return Constant.typeLaunchConfiguration;
	}

	@SuppressWarnings("unchecked")
	public List<WorkParameter> getParameters(
			ILaunchConfiguration configuration) {
		List<WorkParameter> parameters = new ArrayList<WorkParameter>();
		try {
			WorkParameter param = createOneWorkParameter("org.eclipse.acceleo.ide.ui.ARGUMENTS",Direction.IN,Messages.LaunchDriverAcceleo_1,false,String.class); //$NON-NLS-1$
			param.setValue(createStringValue(configuration.getAttribute("org.eclipse.acceleo.ide.ui.ARGUMENTS",(String)null))); //$NON-NLS-1$
			parameters.add(param);
			
			WorkParameter param2 = createOneWorkParameter("org.eclipse.acceleo.ide.ui.LAUNCHING_STRATEGY_DESCRIPTION",Direction.IN,Messages.LaunchDriverAcceleo_4,true,String.class); //$NON-NLS-1$
			param2.setValue(createStringValue(configuration.getAttribute("org.eclipse.acceleo.ide.ui.LAUNCHING_STRATEGY_DESCRIPTION",(String)null))); //$NON-NLS-1$
			parameters.add(param2);

			WorkParameter param3 = createOneWorkParameter("org.eclipse.acceleo.ide.ui.MODEL_PATH",Direction.IN,Messages.LaunchDriverAcceleo_7,true,String.class); //$NON-NLS-1$
			param3.setValue(createStringValue(configuration.getAttribute("org.eclipse.acceleo.ide.ui.MODEL_PATH",(String)null))); //$NON-NLS-1$
			parameters.add(param3);
			
			WorkParameter param4 = createOneWorkParameter("org.eclipse.acceleo.ide.ui.TARGET_PATH",Direction.OUT,Messages.LaunchDriverAcceleo_10,true,String.class); //$NON-NLS-1$
			param4.setValue(createStringValue(configuration.getAttribute("org.eclipse.acceleo.ide.ui.TARGET_PATH",(String)null))); //$NON-NLS-1$
			parameters.add(param4);
			
			WorkParameter param5 = createOneWorkParameter("org.eclipse.debug.core.MAPPED_RESOURCE_PATHS",Direction.IN,Messages.LaunchDriverAcceleo_13,true,List.class); //$NON-NLS-1$
			param5.setValue(createStringListValue(configuration.getAttribute("org.eclipse.debug.core.MAPPED_RESOURCE_PATHS",(List<String>)null))); //$NON-NLS-1$
			parameters.add(param5);
			
			WorkParameter param6 = createOneWorkParameter("org.eclipse.debug.core.MAPPED_RESOURCE_TYPES",Direction.IN,Messages.LaunchDriverAcceleo_16,true,List.class); //$NON-NLS-1$
			param6.setValue(createStringListValue(configuration.getAttribute("org.eclipse.debug.core.MAPPED_RESOURCE_TYPES",(List<String>)null))); //$NON-NLS-1$
			parameters.add(param6);
			
			WorkParameter param7 = createOneWorkParameter("org.eclipse.jdt.launching.MAIN_TYPE",Direction.IN,Messages.LaunchDriverAcceleo_19,true,String.class); //$NON-NLS-1$
			param7.setValue(createStringValue(configuration.getAttribute("org.eclipse.jdt.launching.MAIN_TYPE",(String)null))); //$NON-NLS-1$
			parameters.add(param7);
			
			WorkParameter param8 = createOneWorkParameter("org.eclipse.jdt.launching.PROGRAM_ARGUMENTS",Direction.IN,Messages.LaunchDriverAcceleo_22,true,String.class); //$NON-NLS-1$
			param8.setValue(createStringValue(configuration.getAttribute("org.eclipse.jdt.launching.PROGRAM_ARGUMENTS",(String)null))); //$NON-NLS-1$
			parameters.add(param8);
			
			WorkParameter param9 = createOneWorkParameter("org.eclipse.jdt.launching.PROJECT_ATTR",Direction.IN,Messages.LaunchDriverAcceleo_25,true,String.class); //$NON-NLS-1$
			param9.setValue(createStringValue(configuration.getAttribute("org.eclipse.jdt.launching.PROJECT_ATTR",(String)null))); //$NON-NLS-1$
			parameters.add(param9);
			
		} catch (CoreException e) {
			e.printStackTrace();
		}

		return parameters;
	}	
}
