/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.driver.mofscript.ui;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.gmt.modisco.workflow.AbstractDriverCore;
import org.eclipse.gmt.modisco.workflow.DriverInterface;
import org.eclipse.gmt.modisco.workflow.driver.mofscript.Constant;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Direction;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameter;
import org.eclipse.gmt.mofscript.launch.MOFScriptLaunchConstants;

public class LaunchDriverMOFScript extends AbstractDriverCore implements DriverInterface {

	@Override
	public String getTypeLaunchConfig() {
		return Constant.typeLaunchConfiguration;
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<WorkParameter> getParameters(ILaunchConfiguration configuration) {
		List<WorkParameter> parameters = new ArrayList<WorkParameter>();
		try {
			WorkParameter param = createOneWorkParameter(MOFScriptLaunchConstants.mofScriptOutput,Direction.OUT,"Transformation output path",true,String.class);
			param.setValue(createStringValue(configuration.getAttribute(MOFScriptLaunchConstants.mofScriptOutput,(String)null)));
			parameters.add(param);

			WorkParameter param2 = createOneWorkParameter(MOFScriptLaunchConstants.mofScriptParam,Direction.INOUT,"Transformation parameters inputs and outputs",true,List.class);
			param2.setValue(createStringListValue(configuration.getAttribute(MOFScriptLaunchConstants.mofScriptParam,(List<String>)null)));
			parameters.add(param2);
			
			WorkParameter param3 = createOneWorkParameter(MOFScriptLaunchConstants.mofScriptParamNumber,Direction.IN,"Parameters number",true,Integer.class);
			param3.setValue(createIntegerValue(configuration.getAttribute(MOFScriptLaunchConstants.mofScriptParamNumber,0)));
			parameters.add(param3);
			
			WorkParameter param4 = createOneWorkParameter(MOFScriptLaunchConstants.mofScriptTransformation,Direction.IN,"Transformation path",true,String.class);
			param4.setValue(createStringValue(configuration.getAttribute(MOFScriptLaunchConstants.mofScriptTransformation,(String)null)));
			parameters.add(param4);
		} catch (CoreException e) {
			e.printStackTrace();
		}
		return parameters;
	}
}
