/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.defaultengine;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmt.modisco.workflow.Constants;
import org.eclipse.gmt.modisco.workflow.MoDiscoWorkflowLaunchConstants;
import org.eclipse.gmt.modisco.workflow.WorkflowModelInterface;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Element;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.ModiscoworkflowFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

/**
 * 
 * @author Nicolas Payneau
 */
@SuppressWarnings("unchecked")
public class WorkflowModelImpl implements WorkflowModelInterface {

	private List<Element> moDiscoElementList;
	
	public void addComponentWorkflow(EObject eModiscowork) {
		Element moDiscoWork = (Element)eModiscowork;
		this.moDiscoElementList.add(moDiscoWork);
	}

	public List<EObject> getAllComponents() {
		List<? extends EObject> listComponents = this.moDiscoElementList;
		return (List<EObject>) listComponents;
	}

	public EObject getComponent(int index) {
		return this.moDiscoElementList.get(index);
	}

	public void initialization(ILaunchConfiguration configuration, String path) {
		 try {
			this.moDiscoElementList = stringListToElementList(configuration.getAttribute(MoDiscoWorkflowLaunchConstants.moDiscoListMinimalist,new ArrayList<String>()));
		} catch (CoreException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Allows to transform a string list to element list
	 * @param stringList String list source
	 * @return Created element list
	 */
	private List<Element> stringListToElementList(List<String> stringList) {
		List<Element> moDiscoList = new ArrayList<Element>();
		for(int i=0; i<stringList.size(); i=i+3){
			Element modisco = null;
			//if it'is a Composite
			if(stringList.get(i+2).equals(MoDiscoWorkflowLaunchConstants.launchTypeMoDiscoWorkflow)){
				modisco = ModiscoworkflowFactory.eINSTANCE.createWorkflow();
			}else{
				modisco = ModiscoworkflowFactory.eINSTANCE.createWork();
			}
			modisco.setName(stringList.get(i));
			modisco.setIndex(Integer.valueOf(stringList.get(i+1)));
			modisco.setType(stringList.get(i+2));
			moDiscoList.add(modisco);
		}
		return moDiscoList;
	}

	public void moveResource(String path) {}

	public void removeComponent(int index) {
		this.moDiscoElementList.remove(index);		
	}

	public void removeResource(String resourcePath) {}

	public void save(ILaunchConfigurationWorkingCopy configuration, boolean onlyLaunch) {
		List<String> listString = new ArrayList<String>();
		for(Element modisco : this.moDiscoElementList){
			listString.add(modisco.getName());
			listString.add(Integer.toString(modisco.getIndex()));
			listString.add(modisco.getType());
		}
		configuration.setAttribute(MoDiscoWorkflowLaunchConstants.moDiscoListMinimalist,listString);
	}
	
	public void saveLaunchConfiguration(ILaunchConfigurationWorkingCopy configuration){
		List<String> listString = new ArrayList<String>();
		for(Element modisco : this.moDiscoElementList){
			listString.add(modisco.getName());
			listString.add(Integer.toString(modisco.getIndex()));
			listString.add(modisco.getType());
		}
		configuration.setAttribute(MoDiscoWorkflowLaunchConstants.moDiscoListMinimalist,listString);

	}

	public void setComponent(int index,
			EObject moDiscoWork) {
		Element modisco = (Element)moDiscoWork;
		this.moDiscoElementList.set(index,modisco);
	}

	public void exportWorkflow(ILaunchConfiguration configuration, String outputPath) {
		Set<File> files = new HashSet<File>();
		File fileRoot = null;
		if (!configuration.isLocal()) {				
			IPath path = configuration.getFile().getLocation();
			fileRoot = path.toFile();
		} else {
			fileRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().append(Constants.metadataFolderName).append(Constants.pluginsFolderName).append(Constants.debugCoreFolderName).append(Constants.launchesFolderName).append(configuration.getName()).addFileExtension(Constants.launchExtension).toFile();
		}
		files.add(fileRoot);
		IPath pathOut = new Path(outputPath);
		String nameFile = fileRoot.getName().substring(0,fileRoot.getName().lastIndexOf(".")).concat(".zip"); //$NON-NLS-1$ //$NON-NLS-2$
		pathOut = pathOut.append(nameFile);
		createListLaunchConfig(configuration,files);
		createZip(files,pathOut.toFile());
	}

	/**
	 * Allows to create an archive
	 * @param files File list of archive
	 * @param outputFile The file representing the archive
	 */
	private void createZip(Set<File> files, File outputFile){
		int bufferZip = 2048;
		byte data[] = new byte[bufferZip];
		try {
			FileOutputStream dest = new FileOutputStream(outputFile);
			BufferedOutputStream buff = new BufferedOutputStream(dest);
			ZipOutputStream out = new ZipOutputStream(buff);
			out.setMethod(ZipOutputStream.DEFLATED);
			out.setLevel(9);
			for(File file : files) {
				FileInputStream fi = new FileInputStream(file);
				BufferedInputStream buffi = new BufferedInputStream(fi, bufferZip);
				ZipEntry entry = new ZipEntry(file.getName());
				out.putNextEntry(entry);	
				int count;
				while((count = buffi.read(data, 0, bufferZip)) != -1) {
					out.write(data, 0, count);
				}
				out.closeEntry();
				buffi.close();
			}
			out.close();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * Allows to find the good instance of LaunchConfiguration corresponding at name
	 * @param configName Name of LaunchConfiguration
	 * @return An instance of launchConfiguration corresponding at name
	 */
	private ILaunchConfiguration getLaunchConfigurationFromName(String configName){
		ILaunchConfiguration configuration = null;
		try {
			for(ILaunchConfiguration config : DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations()){
				if(config.getName().equals(configName)){
					configuration = config;
					break;
				}
			}
		} catch (CoreException e) {
			e.printStackTrace();
		}
		return configuration;
	}
	
	/**
	 * Allows to retrieve all launch configuration files.
	 * @param configuration Launch configuration of MoDiscoWorkflow
	 * @param files List of file (.launch) attach to launchConfiguration
	 */
	private void createListLaunchConfig(ILaunchConfiguration configuration,
			Set<File> files) {
		try {
			List<String> moDiscoList = configuration.getAttribute(MoDiscoWorkflowLaunchConstants.moDiscoListMinimalist, (List<String>)null);
			for(int i=0; i<moDiscoList.size(); i=i+3){
				ILaunchConfiguration config = this.getLaunchConfigurationFromName(moDiscoList.get(i));
				if (!config.isLocal()) {				
					IPath path = config.getFile().getLocation();
					files.add(path.toFile());
				} else {
					files.add(ResourcesPlugin.getWorkspace().getRoot().getLocation().append(Constants.metadataFolderName).append(Constants.pluginsFolderName).append(Constants.debugCoreFolderName).append(Constants.launchesFolderName).append(config.getName()).addFileExtension(Constants.launchExtension).toFile());
				}
			}
		} catch (CoreException e) {
			e.printStackTrace();
		}
	}

	public void downMoDiscoWork(int indexSelected) {
		Element modisco = this.moDiscoElementList.get(indexSelected);
		modisco.setIndex(indexSelected+1);
		Element modisco2 = this.moDiscoElementList.get(indexSelected+1);
		modisco2.setIndex(indexSelected);
		this.moDiscoElementList.set(indexSelected+1, modisco);
		this.moDiscoElementList.set(indexSelected, modisco2);
	}

	public void upMoDisoWork(int indexSelected) {
		Element modisco = this.moDiscoElementList.get(indexSelected);
		modisco.setIndex(indexSelected-1);
		Element modisco2 = this.moDiscoElementList.get(indexSelected-1);
		modisco2.setIndex(indexSelected);
		this.moDiscoElementList.set(indexSelected-1, modisco);
		this.moDiscoElementList.set(indexSelected, modisco2);
	}

	public void synchronization(List<Element> allMoDiscoWork) {
		//Not synchronization		
	}
}
