/*******************************************************************************
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 *******************************************************************************/
package org.eclipse.gmt.modisco.workflow.ui.common;

import java.net.URL;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.gmt.modisco.workflow.Constants;
import org.eclipse.gmt.modisco.workflow.DriverInterface;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

/**
 * Tools box. It's a singleton
 * @author Nicolas Payneau
 */
public class Common {
	
	private static Common common = null;
	
	private Common(){}
	
	/**
	 * Allows to retrieve a point allowing to center our shell
	 * @parameter shell Our shell which we want to center
	 * @parameter display The display on which open the shell
	 * @return Return a point
	 */
	public Point centerShell(Display display, Shell shell) {  
		Rectangle rect = display.getClientArea();  
		Point size = shell.getSize();  
		int x = (rect.width - size.x) / 2;  
		int y = (rect.height - size.y) / 2;  
		return new Point(x, y);  
	}
	
	/**
	 * Allows to retrieve the driver image corresponding to given type
	 * @parameter type Launcher type
	 * @return The image of the driver at the specified launcher type
	 */
	public Image retrieveImageDriver(String type){
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IExtensionPoint point = registry.getExtensionPoint(Constants.nameExtensionPointDriver); 

		for (IExtension extension : point.getExtensions()) {
			for (IConfigurationElement element : extension.getConfigurationElements()) {
				if(element.getName().equals(Constants.nameElementDriver)){
					try {
						if(((DriverInterface)element.createExecutableExtension("class")).getTypeLaunchConfig().equals(type)){ //$NON-NLS-1$
							Bundle b =Platform.getBundle(extension.getNamespaceIdentifier());
							URL url = b.getResource(element.getAttribute("icon")); //$NON-NLS-1$
							return ImageDescriptor.createFromURL(url).createImage();
						}
					} catch (InvalidRegistryObjectException e) {
						e.printStackTrace();
					} catch (CoreException e) {
						e.printStackTrace();
					}
				}
			}
		}
		return null;
	}
	
	/**
	 * Allows to refresh the package explorer
	 */
	public void refreshPackageExplorer(){
		try {
			ResourcesPlugin.getWorkspace().getRoot().refreshLocal(IResource.DEPTH_INFINITE, new NullProgressMonitor());
		} catch (CoreException e) {
			e.printStackTrace();
		}
	}
	
	/**
	 * Allows to retrieve the singleton
	 * @return Return the singleton
	 */
	public static Common getInstance(){
		if(Common.common==null){
			Common.common = new Common();
		}
		return Common.common;
	}
}
