/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.controller;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.gmt.modisco.workflow.DriverExecutionInterface;
import org.eclipse.gmt.modisco.workflow.DriverInterface;
import org.eclipse.gmt.modisco.workflow.ui.DriverPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControllerDriverPage {
    private DriverPage driverPage;
    private HashMap<String, DriverInterface> mapNameDrivers = new HashMap();
    private DriverInterface currentDriver;
    private ILaunchConfigurationWorkingCopy configurationEdition;
    private String typeEdition;

    public ControllerDriverPage() {
        this.initialization();
    }

    public void refreshDriverPage(String type) {
        if (this.mapNameDrivers.size() != 0) {
            this.currentDriver = this.mapNameDrivers.get(this.getDriverNameFromLaunchType(type));
            if (this.currentDriver != null) {
                this.driverPage.createTab(this.currentDriver.getTypeLaunchConfig());
            }
        }
        this.driverPage.setTitle(this.getDriverNameFromLaunchType(type));
        this.driverPage.refresh();
    }

    private void initialization() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.gmt.modisco.driver");
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals("driverUI")) {
                    try {
                        this.mapNameDrivers.put(element.getAttribute("name"), (DriverInterface)element.createExecutableExtension("class"));
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    public ILaunchConfigurationWorkingCopy launchPerformFinish() {
        return this.driverPage.performApply();
    }

    public String getDriverNameFromLaunchType(String LaunchType) {
        String name = null;
        for (Map.Entry<String, DriverInterface> entry : this.mapNameDrivers.entrySet()) {
            if (!entry.getValue().getTypeLaunchConfig().equals(LaunchType)) continue;
            name = entry.getKey();
            break;
        }
        return name;
    }

    public DriverInterface getDriverFromLaunchType(String LaunchType) {
        return this.mapNameDrivers.get(this.getDriverNameFromLaunchType(LaunchType));
    }

    public DriverExecutionInterface findPlugIn(String type) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.gmt.modisco.driver");
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (element.getName().equals("driverUI")) {
                    try {
                        DriverInterface driver = (DriverInterface)element.createExecutableExtension("class");
                        if (driver.getTypeLaunchConfig().equals(type)) {
                            return this.findExecutionPlugIn(extension.getSimpleIdentifier());
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private DriverExecutionInterface findExecutionPlugIn(String id) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.gmt.modisco.driver");
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            if (extension.getSimpleIdentifier().equals(id)) {
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    if (element.getName().equals("execution")) {
                        try {
                            return (DriverExecutionInterface)element.createExecutableExtension("class");
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    public ILaunchConfigurationWorkingCopy getConfigurationEdition() {
        return this.configurationEdition;
    }

    public String getTypeEdition() {
        return this.typeEdition;
    }

    public void setConfigurationEdition(ILaunchConfigurationWorkingCopy configuration) {
        this.configurationEdition = configuration;
    }

    public void setTypeEdition(String type) {
        this.typeEdition = type;
    }

    public DriverInterface getCurrentDriver() {
        return this.currentDriver;
    }

    public void setDriverPage(DriverPage driverPage) {
        this.driverPage = driverPage;
    }

    public HashMap<String, DriverInterface> getMapNameDriver() {
        return this.mapNameDrivers;
    }

    public DriverPage getDriverPage() {
        return this.driverPage;
    }
}

