/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.ui;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.MoDiscoWorkflowLaunchConstants;
import org.eclipse.gmt.modisco.workflow.controller.ControllerWorkflowTransformation;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.WorkParameter;
import org.eclipse.gmt.modisco.workflow.ui.Messages;
import org.eclipse.gmt.modisco.workflow.ui.common.AdditionalButtonsComposite;
import org.eclipse.gmt.modisco.workflow.ui.common.MoDiscoWorkflowPopPup;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class WorkflowTransformationTab
extends AbstractLaunchConfigurationTab {
    private Composite rootContainer;
    private Table transformationsTable;
    private TableViewer paramTable;
    private Composite compositeParameter;
    private AdditionalButtonsComposite gpButtonTransformation;
    private MoDiscoWorkflowPopPup popUp;
    private ControllerWorkflowTransformation controller;
    private boolean isValid;
    private String resourcePath;
    private ExpandItem itemParam;
    private ExpandBar bar;
    private Label labNoParam;
    private state barState;

    public void createControl(Composite parent) {
        this.rootContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        this.rootContainer.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label labelWFTransfo = new Label(this.rootContainer, 0);
        labelWFTransfo.setText(Messages.WorkflowTransformationTab_0);
        GridData gdLabel = new GridData();
        gdLabel.horizontalSpan = 3;
        labelWFTransfo.setLayoutData((Object)gdLabel);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.transformationsTable = new Table(this.rootContainer, 2560);
        this.transformationsTable.setLayoutData((Object)gridData);
        this.transformationsTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                WorkflowTransformationTab.this.dialogChangedContainer();
                WorkflowTransformationTab.this.loadParameter();
                WorkflowTransformationTab.this.itemParam.setHeight(((WorkflowTransformationTab)WorkflowTransformationTab.this).compositeParameter.getBounds().height);
            }
        });
        this.transformationsTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent evt) {
                Point p = new Point(evt.x, evt.y);
                TableItem item = WorkflowTransformationTab.this.transformationsTable.getItem(p);
                if (evt.button == 3) {
                    if (item == null) {
                        WorkflowTransformationTab.this.popUp.createPopupMenuNoSelectionItem(WorkflowTransformationTab.this.getShell());
                        WorkflowTransformationTab.this.transformationsTable.setMenu(WorkflowTransformationTab.this.popUp.getMenuNoSelection());
                    } else {
                        WorkflowTransformationTab.this.popUp.createPopupMenuSelectionItem(WorkflowTransformationTab.this.getShell());
                        WorkflowTransformationTab.this.transformationsTable.setMenu(WorkflowTransformationTab.this.popUp.getMenuSelection());
                    }
                }
            }
        });
        this.gpButtonTransformation = new AdditionalButtonsComposite(this.rootContainer, 0, this.transformationsTable, this.controller);
        this.popUp = new MoDiscoWorkflowPopPup(this.gpButtonTransformation);
        this.createParameterBar();
        this.setControl((Control)this.rootContainer);
    }

    private void createParameterBar() {
        this.bar = new ExpandBar(this.rootContainer, 768);
        GridData gridDataBar = new GridData();
        gridDataBar.horizontalSpan = 2;
        gridDataBar.grabExcessHorizontalSpace = true;
        gridDataBar.horizontalAlignment = 4;
        gridDataBar.verticalAlignment = 3;
        this.bar.setLayoutData((Object)gridDataBar);
        this.bar.addExpandListener(new ExpandListener(){

            public void itemCollapsed(ExpandEvent e) {
                WorkflowTransformationTab.this.barState = state.collapse;
            }

            public void itemExpanded(ExpandEvent e) {
                WorkflowTransformationTab.this.barState = state.expand;
            }
        });
        this.bar.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (!WorkflowTransformationTab.this.itemParam.getExpanded()) {
                    if (WorkflowTransformationTab.this.barState == state.collapse) {
                        WorkflowTransformationTab.this.barState = state.block;
                        WorkflowTransformationTab.this.transformationsTable.notifyListeners(13, null);
                    }
                } else if (WorkflowTransformationTab.this.barState == state.expand) {
                    WorkflowTransformationTab.this.barState = state.block;
                    WorkflowTransformationTab.this.transformationsTable.notifyListeners(13, null);
                }
            }
        });
        this.compositeParameter = new Composite((Composite)this.bar, 0);
        GridLayout layoutParameter = new GridLayout();
        layoutParameter.marginBottom = 10;
        layoutParameter.marginTop = 10;
        layoutParameter.verticalSpacing = 10;
        GridData gdParam = new GridData();
        gdParam.grabExcessHorizontalSpace = true;
        gdParam.grabExcessVerticalSpace = true;
        this.compositeParameter.setLayoutData((Object)gdParam);
        this.compositeParameter.setLayout((Layout)layoutParameter);
        this.createParameterTable(false);
        this.itemParam = new ExpandItem(this.bar, 0, 0);
        this.itemParam.setText(Messages.WorkflowTransformationTab_1);
        this.itemParam.setControl((Control)this.compositeParameter);
        this.itemParam.setHeight(this.compositeParameter.computeSize((int)-1, (int)-1).y);
    }

    private void createParameterTable(boolean parameter) {
        Control[] controlArray = this.compositeParameter.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        if (!parameter) {
            this.labNoParam = new Label(this.compositeParameter, 0);
            this.labNoParam.setText(Messages.WorkflowTransformationTab_2);
        } else {
            this.paramTable = new TableViewer(this.compositeParameter, 68096);
            GridData gridData1 = new GridData();
            gridData1.grabExcessHorizontalSpace = true;
            gridData1.horizontalAlignment = 4;
            gridData1.verticalAlignment = 4;
            gridData1.grabExcessVerticalSpace = true;
            this.paramTable.getTable().setLayoutData((Object)gridData1);
            this.paramTable.getTable().setHeaderVisible(true);
            this.paramTable.getTable().setLinesVisible(true);
            TableColumnLayout ad = new TableColumnLayout();
            this.compositeParameter.setLayout((Layout)ad);
            TableViewerColumn columnDirection = new TableViewerColumn(this.paramTable, 0);
            columnDirection.getColumn().setText(Messages.WorkflowTransformationTab_3);
            columnDirection.getColumn().setMoveable(true);
            ad.setColumnData((Widget)columnDirection.getColumn(), (ColumnLayoutData)new ColumnWeightData(26, 60));
            TableViewerColumn columnName = new TableViewerColumn(this.paramTable, 0);
            columnName.getColumn().setText(Messages.WorkflowTransformationTab_4);
            columnName.getColumn().setMoveable(true);
            ad.setColumnData((Widget)columnName.getColumn(), (ColumnLayoutData)new ColumnWeightData(26, 100));
            TableViewerColumn columnType = new TableViewerColumn(this.paramTable, 0);
            columnType.getColumn().setText(Messages.WorkflowTransformationTab_5);
            columnType.getColumn().setMoveable(true);
            ad.setColumnData((Widget)columnType.getColumn(), (ColumnLayoutData)new ColumnWeightData(26, 100));
            TableViewerColumn columnRequired = new TableViewerColumn(this.paramTable, 0);
            columnRequired.getColumn().setText(Messages.WorkflowTransformationTab_6);
            columnRequired.getColumn().setMoveable(true);
            ad.setColumnData((Widget)columnRequired.getColumn(), (ColumnLayoutData)new ColumnWeightData(26, 60));
            TableViewerColumn columnDescription = new TableViewerColumn(this.paramTable, 0);
            columnDescription.getColumn().setText(Messages.WorkflowTransformationTab_7);
            columnDescription.getColumn().setMoveable(true);
            ad.setColumnData((Widget)columnDescription.getColumn(), (ColumnLayoutData)new ColumnWeightData(26, 200));
            GridData gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
            this.compositeParameter.setLayoutData((Object)gridData);
        }
    }

    private void loadParameter() {
        List<WorkParameter> paramList = null;
        if (this.transformationsTable.getSelectionIndex() != -1) {
            paramList = this.controller.getAllParameterOfDriver(this.transformationsTable.getSelectionIndex());
        }
        if (paramList != null) {
            this.createParameterTable(true);
            this.paramTable.getTable().removeAll();
            for (WorkParameter param : paramList) {
                TableItem item = new TableItem(this.paramTable.getTable(), 0);
                item.setText(new String[]{param.getDirection().toString(), param.getName(), param.getType(), Boolean.toString(param.isRequired()), param.getDescription()});
            }
            this.paramTable.getTable().pack();
        } else {
            this.createParameterTable(false);
            this.labNoParam.pack();
        }
        this.compositeParameter.pack();
    }

    private void updateStatus(String message) {
        this.setMessage(Messages.WorkflowTransformationTab_8);
        this.setErrorMessage(message);
        this.isValid = message == null;
        this.rootContainer.setSize(this.rootContainer.computeSize(-1, -1));
        this.rootContainer.layout();
        this.compositeParameter.layout();
        this.updateLaunchConfigurationDialog();
    }

    private void dialogChangedContainer() {
        String transformationName = this.controller.allComponentsHaveConfiguration();
        if (transformationName != null) {
            this.updateStatus(NLS.bind((String)Messages.WorkflowTransformationTab_9, (Object[])new Object[]{transformationName}));
            this.gpButtonTransformation.enabledButtonToManageMoDiscoWorkflow(false);
            this.popUp.enabledButtonToManageMoDiscoWorkflow(false);
            return;
        }
        this.gpButtonTransformation.enabledButtonToManageMoDiscoWorkflow(true);
        this.popUp.enabledButtonToManageMoDiscoWorkflow(true);
        this.updateStatus(null);
    }

    public String getName() {
        return Messages.WorkflowTransformationTab_10;
    }

    public Image getImage() {
        return Activator.getImageDescriptor("icon/modiscoWorkflow.png").createImage();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.isValid;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String id = configuration.getAttribute(MoDiscoWorkflowLaunchConstants.idWorkflow, MoDiscoWorkflowLaunchConstants.idMinimaliste);
            this.controller = new ControllerWorkflowTransformation(id, configuration.getName());
            this.controller.setGroup(DebugUITools.getLaunchGroup((ILaunchConfiguration)configuration, null));
            this.gpButtonTransformation.setController(this.controller);
            this.controller.initializationWorkflowResource(configuration, this.resourcePath);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.controller.refresh(-1);
        this.dialogChangedContainer();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.controller.saveWorkflowResource(configuration, true);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public ControllerWorkflowTransformation getController() {
        return this.controller;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum state {
        expand,
        collapse,
        block;

    }
}

