/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.ui.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Constants;
import org.eclipse.gmt.modisco.workflow.controller.ControllerWorkflowTransformation;
import org.eclipse.gmt.modisco.workflow.ui.common.Common;
import org.eclipse.gmt.modisco.workflow.ui.common.Messages;
import org.eclipse.gmt.modisco.workflow.ui.common.RemoveDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdditionalButtonsComposite
extends Composite {
    private Button newButton = null;
    private Button editButton = null;
    private Button removeButton = null;
    private Button upButton = null;
    private Button downButton = null;
    private Button loadButton = null;
    private Table tableAssociee;
    private ControllerWorkflowTransformation controller;

    public AdditionalButtonsComposite(Composite parent, int style, Table table, ControllerWorkflowTransformation controller) {
        super(parent, style);
        this.tableAssociee = table;
        this.controller = controller;
        this.initialize();
    }

    private void initialize() {
        GridData gridDataUp = new GridData();
        gridDataUp.horizontalAlignment = 4;
        gridDataUp.verticalAlignment = 2;
        GridData gridDataDown = new GridData();
        gridDataDown.horizontalAlignment = 4;
        gridDataDown.verticalAlignment = 2;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 2;
        this.newButton = new Button((Composite)this, 0);
        this.newButton.setText(Messages.AdditionalButtonsComposite_0);
        this.newButton.setLayoutData((Object)gridData);
        this.newButton.setImage(Activator.getImageDescriptor("icon/addMoDiscoWork.png").createImage());
        this.newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdditionalButtonsComposite.this.newAdditionalMoDiscoWork();
            }
        });
        this.editButton = new Button((Composite)this, 0);
        this.editButton.setText(Messages.AdditionalButtonsComposite_1);
        this.editButton.setLayoutData((Object)gridData);
        this.editButton.setImage(Activator.getImageDescriptor("icon/editMoDiscoWork.png").createImage());
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdditionalButtonsComposite.this.editAdditionalMoDiscoWork();
            }
        });
        this.removeButton = new Button((Composite)this, 0);
        this.removeButton.setText(Messages.AdditionalButtonsComposite_2);
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.setImage(Activator.getImageDescriptor("icon/deleteMoDiscoWork.png").createImage());
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdditionalButtonsComposite.this.removeAdditionalMoDiscoWork();
            }
        });
        this.loadButton = new Button((Composite)this, 0);
        this.loadButton.setText(Messages.AdditionalButtonsComposite_3);
        this.loadButton.setLayoutData((Object)gridData);
        this.loadButton.setImage(Activator.getImageDescriptor("icon/loadMoDiscoWork.png").createImage());
        this.loadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdditionalButtonsComposite.this.loadAdditionalTransformation();
            }
        });
        this.upButton = new Button((Composite)this, 8);
        this.upButton.setText(Messages.AdditionalButtonsComposite_4);
        gridDataUp.verticalIndent = 30;
        this.upButton.setLayoutData((Object)gridDataUp);
        this.upButton.setImage(Activator.getImageDescriptor("icon/upMoDiscoWork.png").createImage());
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdditionalButtonsComposite.this.upAdditionalMoDiscoWork();
            }
        });
        this.downButton = new Button((Composite)this, 8);
        this.downButton.setText(Messages.AdditionalButtonsComposite_5);
        this.downButton.setLayoutData((Object)gridDataDown);
        this.downButton.setImage(Activator.getImageDescriptor("icon/downMoDiscoWork.png").createImage());
        this.downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdditionalButtonsComposite.this.downAdditionalMoDiscoWork();
            }
        });
        this.tableAssociee.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                AdditionalButtonsComposite.this.editAdditionalMoDiscoWork();
            }
        });
        GridData layoutData = new GridData();
        layoutData.verticalAlignment = 1;
        this.setSize(new Point(63, 202));
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(layoutData);
    }

    protected final void newAdditionalMoDiscoWork() {
        this.controller.newElement();
    }

    protected final void editAdditionalMoDiscoWork() {
        if (this.tableAssociee.getSelectionIndex() != -1) {
            Constants result = this.controller.editElement(this.tableAssociee.getSelectionIndex());
            if (result.equals((Object)Constants.LaunchConfigurationNotFound)) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.AdditionalButtonsComposite_6, (String)Messages.AdditionalButtonsComposite_7);
            } else if (result.equals((Object)Constants.MoDiscoWorkflowSelected)) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.AdditionalButtonsComposite_8, (String)Messages.AdditionalButtonsComposite_9);
            }
        }
    }

    protected final void removeAdditionalMoDiscoWork() {
        if (this.tableAssociee.getSelectionIndex() != -1) {
            RemoveDialog dialog = new RemoveDialog(this.getShell(), this.tableAssociee.getItem(this.tableAssociee.getSelectionIndex()).getText());
            dialog.open();
            if (dialog.getMode().equals((Object)Constants.deleteFromLauncherMode)) {
                this.controller.removeFromLauncher(this.getAllIndexFromString(this.tableAssociee.getItem(this.tableAssociee.getSelectionIndex()).getText()));
            } else if (dialog.getMode().equals((Object)Constants.deleteFromWorkflowMode)) {
                this.controller.removeFromWorkflow(this.tableAssociee.getSelectionIndex());
            }
        }
    }

    private List<Integer> getAllIndexFromString(String name) {
        ArrayList<Integer> indexList = new ArrayList<Integer>();
        TableItem[] tableItemArray = this.tableAssociee.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getText().equals(name)) {
                indexList.add(this.tableAssociee.indexOf(item));
            }
            ++n2;
        }
        Collections.sort(indexList);
        Collections.reverse(indexList);
        return indexList;
    }

    protected final void upAdditionalMoDiscoWork() {
        if (this.tableAssociee.getSelectionIndex() > 0 && this.tableAssociee.getSelectionIndex() != -1) {
            this.controller.upElement(this.tableAssociee.getSelectionIndex());
            this.controller.refresh(this.tableAssociee.getSelectionIndex() - 1);
        }
    }

    protected final void downAdditionalMoDiscoWork() {
        if (this.tableAssociee.getSelectionIndex() + 1 < this.tableAssociee.getItemCount() && this.tableAssociee.getSelectionIndex() != -1) {
            this.controller.downElement(this.tableAssociee.getSelectionIndex());
            this.controller.refresh(this.tableAssociee.getSelectionIndex() + 1);
        }
    }

    protected void loadAdditionalTransformation() {
        this.controller.loadElement();
    }

    public void createItemTable(String name, String driverType) {
        TableItem item = new TableItem(this.tableAssociee, 0);
        item.setText(name);
        item.setImage(Common.getInstance().retrieveImageDriver(driverType));
    }

    public void refreshTable() {
        this.tableAssociee.notifyListeners(13, null);
    }

    public void dialogLoop() {
        MessageDialog.openError((Shell)this.getShell(), (String)Messages.AdditionalButtonsComposite_10, (String)Messages.AdditionalButtonsComposite_11);
    }

    public Table getTable() {
        return this.tableAssociee;
    }

    public void setController(ControllerWorkflowTransformation controller) {
        controller.setAdditionnalButton(this);
        this.controller = controller;
    }

    public void enabledButtonToManageMoDiscoWorkflow(boolean allRight) {
        if (allRight) {
            this.newButton.setEnabled(true);
            this.editButton.setEnabled(true);
            this.removeButton.setEnabled(true);
            this.upButton.setEnabled(true);
            this.downButton.setEnabled(true);
            this.loadButton.setEnabled(true);
        } else {
            this.newButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.upButton.setEnabled(false);
            this.downButton.setEnabled(false);
            this.loadButton.setEnabled(false);
        }
    }
}

