/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.mofscript.launch;

import java.io.File;
import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.gmt.mofscript.launch.core.MOFScriptCore;

public class LaunchConfigurationDelegate implements
		ILaunchConfigurationDelegate {

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.core.model.ILaunchConfigurationDelegate#launch(org.eclipse.debug.core.ILaunchConfiguration, java.lang.String, org.eclipse.debug.core.ILaunch, org.eclipse.core.runtime.IProgressMonitor)
	 */
	@SuppressWarnings("unchecked")
	public void launch(ILaunchConfiguration configuration, String mode,
			ILaunch launch, IProgressMonitor monitor) throws CoreException {
		MOFScriptCore core = new MOFScriptCore();
		String transformationPath = configuration.getAttribute(MOFScriptLaunchConstants.mofScriptTransformation,"");
		String outputPath = configuration.getAttribute(MOFScriptLaunchConstants.mofScriptOutput, "");
		
		File transformationFile = new File(transformationPath);
		IWorkspace workspace= ResourcesPlugin.getWorkspace();
		IPath location= Path.fromOSString(transformationFile.getAbsolutePath());
		IFile file= workspace.getRoot().getFile(location); 
		core.initialization(file);
		
		List<String> listParam = configuration.getAttribute(MOFScriptLaunchConstants.mofScriptParam,(List<String>)null);

		for(String param : listParam){
			core.loadSourceModel(new File(param));
		}
		core.generate(outputPath);
	}

}
