package org.eclipse.gmt.mofscript.launch;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;


public class LaunchShortcut implements ILaunchShortcut {

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchShortcut#launch(org.eclipse.jface.viewers.ISelection, java.lang.String)
	 */
	public void launch(ISelection selection, String mode) {
		ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(
				new Shell(), new WorkbenchLabelProvider(), new WorkbenchContentProvider());
				
		if (selection instanceof IStructuredSelection) {
			IStructuredSelection select = (IStructuredSelection)selection;
			for(Object object : select.toArray()){
				if (object instanceof IAdaptable) {
					IAdaptable adapt = (IAdaptable)object;
					if(adapt instanceof IFile){
						IFile file = (IFile)adapt;
						launchRunConfiguration(file.getFullPath().toString());
					}else{
						elementTreeSelectionDialog.setInput(object);
						elementTreeSelectionDialog.setMessage("Choose your transformation MOFScript");
					    final ViewerFilter m2tFilter = new ViewerFilter() {
					        public boolean select(
					          Viewer viewer,
					          Object parentElement,
					          Object element) {
					        	return filterTransformationMOFScript(element);
					        }
					      };
						elementTreeSelectionDialog.addFilter(m2tFilter);
						elementTreeSelectionDialog.setAllowMultiple(false);
						elementTreeSelectionDialog.setDoubleClickSelects(true);
						elementTreeSelectionDialog.open();
						Object result = elementTreeSelectionDialog.getFirstResult();

						if ((result != null) && (result instanceof IFile)) {
							IFile currentFile = (IFile)result;
							launchRunConfiguration(currentFile.getFullPath().toString());
						}
					}
				}
				
			}
		}
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.debug.ui.ILaunchShortcut#launch(org.eclipse.ui.IEditorPart, java.lang.String)
	 */
	public void launch(IEditorPart editor, String mode) {
		IEditorInput input = editor.getEditorInput();
		IFile file = (IFile) input.getAdapter(IFile.class);
		launchRunConfiguration(file.getFullPath().toString());
	}
	
	private void launchRunConfiguration(String transformationMOF){
		ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.gmt.mofscript.launchconfiguration.launchConfigurationType");
		ILaunchConfigurationWorkingCopy wc = null;
		ILaunchConfiguration config = null;
		try {
			wc = type.newInstance(null,findName("NewConfig",0));
			wc.setAttribute(MOFScriptLaunchConstants.mofScriptTransformation, transformationMOF);
			config = wc.doSave();
		} catch (CoreException e) {
			e.printStackTrace();
		}
		IStructuredSelection select = new StructuredSelection(config);
		DebugUITools.openLaunchConfigurationDialogOnGroup(PlatformUI.createDisplay().getActiveShell(), select, IDebugUIConstants.ID_RUN_LAUNCH_GROUP);
	}
	
	private String findName(String name, final int count){
		int internCount = count;
		String findName = name+internCount;
		try {
			for(ILaunchConfiguration configuration : DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations()){
				if(configuration.getName().equals(findName)){
					findName = findName(name, ++internCount);
					break;
				}
			}
		} catch (CoreException e) {
			e.printStackTrace();
		}
		return findName;
	}
	
	private boolean filterTransformationMOFScript(Object element) {
		boolean isValid = false;
		try {
			if(element instanceof IContainer){
				for(IResource resource : ((IContainer)element).members()){
					if(filterTransformationMOFScript(resource)){
						isValid = true;
						break;
					}
				}
			}else if(element instanceof IFile){
	    		if(isValidExtension(((IFile)element).getFullPath().toString())){
	    			isValid=true;
	    		}
			}
		} catch (CoreException e) {
			e.printStackTrace();
		}
		return isValid;
	}

	private boolean isValidExtension(String path) {
		boolean isValid = true;
		int dotLoc = path.lastIndexOf('.');
		if (dotLoc != -1) {
			String ext = path.substring(dotLoc + 1);
			if (!ext.equalsIgnoreCase("m2t")) {
				isValid = false;
			}
		}
		return isValid;
	}
}
