/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.mofscript.launch.common;

import java.io.File;

import org.eclipse.core.resources.IFile;
import org.eclipse.gmt.mofscript.launch.core.MOFScriptCore;
import org.eclipse.gmt.mofscript.launch.ui.MOFScriptTab;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptTransformation;

public class ControllerMOFScript {
	private MOFScriptCore mofscriptCore;
	private MOFScriptTab mofTab;
	
	/*
	 * Class constructor
	 */
	public ControllerMOFScript() {
		this.mofscriptCore = new MOFScriptCore();
		this.mofTab = null;
	}
	
	/*
	 * Load the parameters and launch the transformation MOFScript
	 */
	public void performFinish(){
		for(File file : this.mofTab.getFileParameter()){
			this.mofscriptCore.loadSourceModel(file);
		}
		this.mofscriptCore.generate(this.mofTab.getOutputPath());
	}
	
	/*
	 * Getter of MOFScriptTransformation
	 * @see org.eclipse.mofscript.MOFScriptModel.MOFScriptTransformation
	 */
	public MOFScriptTransformation getMOFScriptTransformation(){
		return this.mofscriptCore.getMOFScriptTransformation();
	}
	
	/*
	 * Setter of MOFScriptTab for the controller
	 * @parameter mofTab The MOFScriptTab which is going to be watched
	 */
	public void setTabMOFScript(MOFScriptTab mofTab){
		this.mofTab = mofTab;
	}
	
	/*
	 * Parse and compile the transformation selected
	 * @parameter selectedFile File of the transformation MOFScript selected
	 */
	public void initialization(IFile selectedFile){
		this.mofscriptCore.initialization(selectedFile);
	}
	
	/*
	 * Getter of error
	 * @return true if compilation generate errors otherwise false
	 */
	public boolean getError(){
		return this.mofscriptCore.getError();
	}
}
