/*
 * Copyright (c) 2009 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Nicolas Payneau (Mia-Software) - initial API and implementation
 */
package org.eclipse.gmt.mofscript.launch.core;

import java.io.File;

import org.eclipse.core.resources.IFile;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptSpecification;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptTransformation;
import org.eclipse.mofscript.editor.ExecutionUtility;
import org.eclipse.mofscript.editor.MofScriptEditorPlugin;
import org.eclipse.mofscript.parser.ParserUtil;
import org.eclipse.mofscript.runtime.ExecutionManager;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;

public class MOFScriptCore {
	private MOFScriptTransformation transformation;
	private MOFScriptSpecification specification;
	private IFile selectedFile;
	private ExecutionManager execMgr;
	private boolean error;
	
	/*
	 * Parse and compile the transformation selected
	 * @parameter selectedFile File of the transformation MOFScript selected
	 */
	@SuppressWarnings("static-access")
	public void initialization(IFile selectedFile){
		if(selectedFile.getLocationURI()!=null){
			this.selectedFile = selectedFile;
			this.execMgr = ExecutionManager.getExecutionManager();
			this.specification = new ExecutionUtility().compile (this.selectedFile, null);
			if(MofScriptEditorPlugin.getDefault().getParserUtil().getModelChecker().getErrorCount()>0){
				this.error=true;
			}else{
				this.transformation = this.specification.getTransformation().get(0);
				this.error=false;
			}
		}
	}

	/*
	 * Load a source file corresponding to a parameter of the transformation selected
	 * @parameter fileSource The file corresponding to a parameter
	 */
	public void loadSourceModel(File fileSourceModel) {
		if(fileSourceModel.getName().endsWith(".m2t")) {
			MOFScriptSpecification inputTransformation = null;
			ParserUtil parser = MofScriptEditorPlugin.getDefault().getParserUtil();			
			//String currentInputFile = MofScriptEditorPlugin.getExecutionUtility().getCurrentInputFile();
			try {				
				inputTransformation = parser.parse(fileSourceModel, true);			
				// MofScriptEditorPlugin.getExecutionUtility().setRootDirectoryProperty()
				new ExecutionUtility().compile (this.selectedFile, null); 						
				ExecutionManager execMgr = ExecutionManager.getExecutionManager();						
				execMgr.addSourceModel(inputTransformation);
			} catch (Exception ex) {
				ex.printStackTrace();
			}	
		}else{
			ExecutionManager.getExecutionManager().loadSourceModel(fileSourceModel);
		}
	}

	/*
	 * Launch the transformation MOFscript selected
	 * @parameter outPutPath Output path for the generation of transformation
	 */
	public void generate(String outPutPath) {
		// sets the root output directory, if any is desired (e.g. "c:/temp")
		this.execMgr.setRootDirectory(outPutPath);
		//execMgr.setRootDirectory("");
		// if true, files are not generated to the file system, but populated into a filemodel
		// which can be fetched afterwards. Value false will result in standard file generation
		this.execMgr.setUseFileModel(false);
		// Turns on/off system logging
		this.execMgr.setUseLog(false);
		// Adds an output listener for the transformation execution.
		//execMgr.getExecutionStack().addOutputMessageListener(this);
		try {
			//MofScriptEditorPlugin.getExecutionUtility().mofScriptTextToModel(this.selectedFile, null, specification);
			this.execMgr.executeTransformation();
		} catch (MofScriptExecutionException mex) {
			mex.printStackTrace();
		}
	}
	
	
	/*
	 * Getter of MOFScriptTransformation
	 * @see org.eclipse.mofscript.MOFScriptModel.MOFScriptTransformation
	 */
	public MOFScriptTransformation getMOFScriptTransformation(){
		return this.transformation;
	}
	
	/*
	 * Getter of error
	 * @return true if compilation generate errors otherwise false
	 */
	public boolean getError(){
		return this.error;
	}
}
