/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.mofscript.launch;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.gmt.mofscript.launch.MOFScriptLaunchConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class LaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(new Shell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection select = (IStructuredSelection)selection;
            Object[] objectArray = select.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof IAdaptable) {
                    IAdaptable adapt = (IAdaptable)object;
                    if (adapt instanceof IFile) {
                        IFile file = (IFile)adapt;
                        this.launchRunConfiguration(file.getFullPath().toString());
                    } else {
                        elementTreeSelectionDialog.setInput(object);
                        elementTreeSelectionDialog.setMessage("Choose your transformation MOFScript");
                        ViewerFilter m2tFilter = new ViewerFilter(){

                            public boolean select(Viewer viewer, Object parentElement, Object element) {
                                return LaunchShortcut.this.filterTransformationMOFScript(element);
                            }
                        };
                        elementTreeSelectionDialog.addFilter(m2tFilter);
                        elementTreeSelectionDialog.setAllowMultiple(false);
                        elementTreeSelectionDialog.setDoubleClickSelects(true);
                        elementTreeSelectionDialog.open();
                        Object result = elementTreeSelectionDialog.getFirstResult();
                        if (result != null && result instanceof IFile) {
                            IFile currentFile = (IFile)result;
                            this.launchRunConfiguration(currentFile.getFullPath().toString());
                        }
                    }
                }
                ++n2;
            }
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        IFile file = (IFile)input.getAdapter(IFile.class);
        this.launchRunConfiguration(file.getFullPath().toString());
    }

    private void launchRunConfiguration(String transformationMOF) {
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.gmt.mofscript.launchconfiguration.launchConfigurationType");
        ILaunchConfigurationWorkingCopy wc = null;
        ILaunchConfiguration config = null;
        try {
            wc = type.newInstance(null, this.findName("NewConfig", 0));
            wc.setAttribute(MOFScriptLaunchConstants.mofScriptTransformation, transformationMOF);
            config = wc.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        StructuredSelection select = new StructuredSelection(config);
        DebugUITools.openLaunchConfigurationDialogOnGroup((Shell)PlatformUI.createDisplay().getActiveShell(), (IStructuredSelection)select, (String)"org.eclipse.debug.ui.launchGroup.run");
    }

    private String findName(String name, int count) {
        int internCount = count;
        String findName = String.valueOf(name) + internCount;
        try {
            ILaunchConfiguration[] iLaunchConfigurationArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations();
            int n = iLaunchConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                if (configuration.getName().equals(findName)) {
                    findName = this.findName(name, ++internCount);
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return findName;
    }

    private boolean filterTransformationMOFScript(Object element) {
        boolean isValid;
        block6: {
            isValid = false;
            try {
                if (element instanceof IContainer) {
                    IResource[] iResourceArray = ((IContainer)element).members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource resource = iResourceArray[n2];
                        if (this.filterTransformationMOFScript(resource)) {
                            isValid = true;
                            break block6;
                        }
                        ++n2;
                    }
                    break block6;
                }
                if (element instanceof IFile && this.isValidExtension(((IFile)element).getFullPath().toString())) {
                    isValid = true;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return isValid;
    }

    private boolean isValidExtension(String path) {
        String ext;
        boolean isValid = true;
        int dotLoc = path.lastIndexOf(46);
        if (dotLoc != -1 && !(ext = path.substring(dotLoc + 1)).equalsIgnoreCase("m2t")) {
            isValid = false;
        }
        return isValid;
    }
}

