/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.mofscript.launch.core;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptSpecification;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptTransformation;
import org.eclipse.mofscript.editor.ExecutionUtility;
import org.eclipse.mofscript.editor.MofScriptEditorPlugin;
import org.eclipse.mofscript.parser.ParserUtil;
import org.eclipse.mofscript.runtime.ExecutionManager;
import org.eclipse.mofscript.runtime.MofScriptExecutionException;

public class MOFScriptCore {
    private MOFScriptTransformation transformation;
    private MOFScriptSpecification specification;
    private IFile selectedFile;
    private ExecutionManager execMgr;
    private boolean error;

    public void initialization(IFile selectedFile) {
        if (selectedFile.getLocationURI() != null) {
            this.selectedFile = selectedFile;
            this.execMgr = ExecutionManager.getExecutionManager();
            this.specification = new ExecutionUtility().compile(this.selectedFile, null);
            MofScriptEditorPlugin.getDefault().getParserUtil();
            if (ParserUtil.getModelChecker().getErrorCount() > 0) {
                this.error = true;
            } else {
                this.transformation = (MOFScriptTransformation)this.specification.getTransformation().get(0);
                this.error = false;
            }
        }
    }

    public void loadSourceModel(File fileSourceModel) {
        if (fileSourceModel.getName().endsWith(".m2t")) {
            MOFScriptSpecification inputTransformation = null;
            ParserUtil parser = MofScriptEditorPlugin.getDefault().getParserUtil();
            try {
                inputTransformation = parser.parse(fileSourceModel, true);
                new ExecutionUtility().compile(this.selectedFile, null);
                ExecutionManager execMgr = ExecutionManager.getExecutionManager();
                execMgr.addSourceModel((EObject)inputTransformation);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            ExecutionManager.getExecutionManager().loadSourceModel(fileSourceModel);
        }
    }

    public void generate(String outPutPath) {
        this.execMgr.setRootDirectory(outPutPath);
        this.execMgr.setUseFileModel(false);
        this.execMgr.setUseLog(false);
        try {
            this.execMgr.executeTransformation();
        }
        catch (MofScriptExecutionException mex) {
            mex.printStackTrace();
        }
    }

    public MOFScriptTransformation getMOFScriptTransformation() {
        return this.transformation;
    }

    public boolean getError() {
        return this.error;
    }
}

