/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.mofscript.launch.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.gmt.mofscript.launch.Activator;
import org.eclipse.gmt.mofscript.launch.MOFScriptLaunchConstants;
import org.eclipse.gmt.mofscript.launch.common.ControllerMOFScript;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.mofscript.MOFScriptModel.MOFScriptParameter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MOFScriptTab
extends AbstractLaunchConfigurationTab {
    private ScrolledComposite scrollContainer;
    private Composite rootContainer;
    private Text containerMOFScriptTransforamtion;
    private Text containerOutputDirectory;
    private Label labelTrans;
    private Label labelOutput;
    private Button buttonBrowse1;
    private Button buttonBrowse;
    protected IWorkbench workbench;
    private String pathTransformation = "";
    private HashMap<Text, String> mapLabel;
    private HashMap<Text, String> mapParam;
    private ControllerMOFScript controller = new ControllerMOFScript();
    private Composite compParameters;

    public MOFScriptTab() {
        this.controller.setTabMOFScript(this);
        this.mapLabel = new HashMap();
        this.mapParam = new HashMap();
    }

    public void createControl(Composite parent) {
        this.scrollContainer = new ScrolledComposite(parent, 768);
        this.scrollContainer.setExpandHorizontal(true);
        this.scrollContainer.setExpandVertical(true);
        this.rootContainer = new Composite((Composite)this.scrollContainer, 0);
        GridLayout layout = new GridLayout();
        this.rootContainer.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        this.scrollContainer.setContent((Control)this.rootContainer);
        this.labelTrans = new Label(this.rootContainer, 0);
        this.labelTrans.setText("MOFScript transformation");
        this.containerMOFScriptTransforamtion = new Text(this.rootContainer, 2052);
        GridData gd = new GridData(768);
        this.containerMOFScriptTransforamtion.setLayoutData((Object)gd);
        this.mapLabel.put(this.containerMOFScriptTransforamtion, this.labelTrans.getText());
        this.containerMOFScriptTransforamtion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MOFScriptTab.this.dialogChangedContainer();
            }
        });
        this.containerMOFScriptTransforamtion.setText(this.pathTransformation);
        this.buttonBrowse = new Button(this.rootContainer, 8);
        this.buttonBrowse.setText("Browse...");
        this.buttonBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFile file = MOFScriptTab.this.handleBrowseWorkspace("Choose your output directory", MOFScriptTab.this.containerMOFScriptTransforamtion);
                if (file != null) {
                    MOFScriptTab.this.updateParameters(file);
                }
            }
        });
        this.labelOutput = new Label(this.rootContainer, 0);
        this.labelOutput.setText("Output directory");
        this.containerOutputDirectory = new Text(this.rootContainer, 2052);
        GridData gdOut = new GridData(768);
        this.containerOutputDirectory.setLayoutData((Object)gdOut);
        this.mapLabel.put(this.containerOutputDirectory, this.labelOutput.getText());
        this.containerOutputDirectory.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MOFScriptTab.this.dialogChangedContainer();
            }
        });
        this.buttonBrowse1 = new Button(this.rootContainer, 8);
        this.buttonBrowse1.setText("Browse...");
        this.buttonBrowse1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MOFScriptTab.this.handleBrowseDirectory("Choose your output directory", MOFScriptTab.this.containerOutputDirectory);
            }
        });
        this.compParameters = new Composite(this.rootContainer, 0);
        GridData gdParam = new GridData(768);
        gdParam.horizontalSpan = 3;
        this.compParameters.setLayoutData((Object)gdParam);
        GridLayout layoutParamter = new GridLayout();
        layoutParamter.numColumns = 3;
        layoutParamter.verticalSpacing = 9;
        this.compParameters.setLayout((Layout)layoutParamter);
        this.setControl((Control)this.scrollContainer);
    }

    private void loadParameter(String message, int direction) {
        int indice = 1;
        boolean present = false;
        Group group = new Group(this.compParameters, 0);
        group.setText(message);
        GridData gdGroup = new GridData(768);
        gdGroup.horizontalSpan = 3;
        group.setLayoutData((Object)gdGroup);
        GridLayout layoutParameter = new GridLayout();
        group.setLayout((Layout)layoutParameter);
        layoutParameter.numColumns = 3;
        layoutParameter.verticalSpacing = 9;
        if (this.controller.getMOFScriptTransformation() != null) {
            for (MOFScriptParameter parameter : this.controller.getMOFScriptTransformation().getParameters()) {
                if (parameter.getDirection().getValue() != direction) continue;
                Label labParam = new Label((Composite)group, 0);
                labParam.setText("Model" + indice + " : " + parameter.getName());
                final Text containerParam = new Text((Composite)group, 2052);
                containerParam.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        MOFScriptTab.this.dialogChangedContainer();
                    }
                });
                GridData gd = new GridData(768);
                containerParam.setLayoutData((Object)gd);
                this.mapParam.put(containerParam, labParam.getText());
                Button buttonBrowse = new Button((Composite)group, 8);
                buttonBrowse.setText("Browse...");
                buttonBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        MOFScriptTab.this.handleBrowseFile("Choose your model", containerParam);
                    }
                });
                labParam.pack();
                containerParam.pack();
                buttonBrowse.pack();
                ++indice;
                present = true;
            }
            if (!present) {
                group.setText("Any " + message);
            }
        }
    }

    private IFile handleBrowseWorkspace(String message, Text container) {
        ElementTreeSelectionDialog elementTreeSelectionDialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        elementTreeSelectionDialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        elementTreeSelectionDialog.setMessage(message);
        elementTreeSelectionDialog.setAllowMultiple(false);
        elementTreeSelectionDialog.setDoubleClickSelects(true);
        elementTreeSelectionDialog.open();
        Object result = elementTreeSelectionDialog.getFirstResult();
        if (result != null && result instanceof IFile) {
            IFile currentFile = (IFile)result;
            container.setText(currentFile.getFullPath().toString());
            return currentFile;
        }
        return null;
    }

    private void handleBrowseDirectory(String message, Text container) {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setText(message);
        dialog.open();
        if (!dialog.getFilterPath().equals("")) {
            container.setText(dialog.getFilterPath());
        }
    }

    private void handleBrowseFile(String message, Text container) {
        FileDialog dialog = new FileDialog(this.getShell());
        dialog.setText(message);
        dialog.open();
        if (!dialog.getFileName().equals("")) {
            container.setText(String.valueOf(dialog.getFilterPath()) + "\\" + dialog.getFileName());
        }
    }

    private void dialogChangedContainer() {
        if (this.controller.getError()) {
            this.updateStatus("Compilation Error. You can't continue");
            return;
        }
        for (Map.Entry<Text, String> path : this.mapLabel.entrySet()) {
            if (path.getKey().getText().length() == 0) {
                this.updateStatus(String.valueOf(path.getValue()) + " container must be specified");
                return;
            }
            if (path.getValue().equals(this.labelTrans.getText())) {
                String ext;
                if (!this.validatePath(path.getKey().getText(), true)) {
                    this.updateStatus("URI invalid for " + path.getValue() + " container");
                    return;
                }
                int dotLoc = path.getKey().getText().lastIndexOf(46);
                if (dotLoc == -1 || (ext = path.getKey().getText().substring(dotLoc + 1)).equalsIgnoreCase("m2t")) continue;
                this.updateStatus("File extension must be \"m2t\"");
                return;
            }
            if (this.validatePath(path.getKey().getText(), false)) continue;
            this.updateStatus("URI invalid for " + path.getValue() + " container");
            return;
        }
        for (Map.Entry<Text, String> path : this.mapParam.entrySet()) {
            if (path.getKey().getText().length() == 0) {
                this.updateStatus(String.valueOf(path.getValue()) + " container must be specified");
                return;
            }
            if (this.validatePath(path.getKey().getText(), false)) continue;
            this.updateStatus("URI invalid for " + path.getValue() + " container");
            return;
        }
        this.updateStatus(null);
    }

    private boolean validatePath(String path, boolean workspace) {
        if (workspace) {
            Path ipath = new Path(path.trim());
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)ipath);
            if (res == null) {
                return false;
            }
            return res.getType() == 1;
        }
        File f = new File(path);
        return f.exists();
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.updateLaunchConfigurationDialog();
    }

    public boolean isValid(ILaunchConfiguration configuration) {
        boolean isValid;
        block6: {
            isValid = true;
            try {
                String mofscriptTransformation = configuration.getAttribute(MOFScriptLaunchConstants.mofScriptTransformation, "");
                String mofscriptOutput = configuration.getAttribute(MOFScriptLaunchConstants.mofScriptOutput, "");
                List mofscriptParam = configuration.getAttribute(MOFScriptLaunchConstants.mofScriptParam, null);
                if (mofscriptTransformation.equals("") || mofscriptOutput.equals("") || mofscriptParam == null) {
                    isValid = false;
                    break block6;
                }
                if (mofscriptParam.size() == 0) {
                    isValid = false;
                    break block6;
                }
                if (!this.validatePath(mofscriptTransformation, true) || !this.validatePath(mofscriptOutput, false)) {
                    isValid = false;
                    break block6;
                }
                for (String param : mofscriptParam) {
                    if (this.validatePath(param, false)) continue;
                    isValid = false;
                    break;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return isValid;
    }

    private void updateParameters(IFile file) {
        this.controller.initialization(file);
        this.disposeAllControlParameter();
        if (!this.controller.getError() && file.getLocationURI() != null) {
            this.loadParameter(MOFScriptLaunchConstants.inParameter, 0);
            this.loadParameter(MOFScriptLaunchConstants.outParameter, 1);
            this.loadParameter(MOFScriptLaunchConstants.inoutParameter, 2);
        }
        this.dialogChangedContainer();
        this.refresh();
    }

    private void disposeAllControlParameter() {
        Control[] controlArray = this.compParameters.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.mapParam.clear();
    }

    private void refresh() {
        Control[] controlArray = this.rootContainer.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control ctrl = controlArray[n2];
            this.setControl(ctrl);
            ++n2;
        }
        this.rootContainer.layout();
    }

    public String getOutputPath() {
        return this.containerOutputDirectory.getText();
    }

    public String getName() {
        return MOFScriptLaunchConstants.tabTitile;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            int ind;
            this.containerMOFScriptTransforamtion.setText(configuration.getAttribute(MOFScriptLaunchConstants.mofScriptTransformation, ""));
            this.containerOutputDirectory.setText(configuration.getAttribute(MOFScriptLaunchConstants.mofScriptOutput, ""));
            File f = new File(this.containerMOFScriptTransforamtion.getText());
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IPath location = Path.fromOSString((String)f.getAbsolutePath());
            IFile file = workspace.getRoot().getFile(location);
            List listParam = configuration.getAttribute(MOFScriptLaunchConstants.mofScriptParam, null);
            this.updateParameters(file);
            if (listParam != null && (ind = listParam.size() - 1) != -1) {
                for (Text param : this.mapParam.keySet()) {
                    param.setText((String)listParam.get(ind));
                    --ind;
                }
            }
            this.dialogChangedContainer();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        ArrayList<String> listParam = new ArrayList<String>();
        configuration.setAttribute(MOFScriptLaunchConstants.mofScriptTransformation, this.containerMOFScriptTransforamtion.getText());
        configuration.setAttribute(MOFScriptLaunchConstants.mofScriptOutput, this.containerOutputDirectory.getText());
        configuration.setAttribute(MOFScriptLaunchConstants.mofScriptParamNumber, this.mapParam.size());
        for (Text param : this.mapParam.keySet()) {
            if (param.getText().equals("")) continue;
            listParam.add(param.getText());
        }
        configuration.setAttribute(MOFScriptLaunchConstants.mofScriptParam, listParam);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public List<File> getFileParameter() {
        ArrayList<File> listFile = new ArrayList<File>();
        for (Text parameter : this.mapParam.keySet()) {
            File file = new File(parameter.getText());
            listFile.add(file);
        }
        return listFile;
    }

    public Image getImage() {
        return Activator.getImageDescriptor("/icon/mofScript_logo.png").createImage();
    }
}

