/*
 * Copyright (c) 2010 Mia-Software.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Gabriel Barbier (Mia-Software) - initial API and implementation
 */

package org.eclipse.modisco.prefuse.examples.graphview;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

import prefuse.data.Graph;
import prefuse.data.io.GraphMLReader;
import prefuse.util.GraphLib;
import prefuse.util.ui.UILib;

/**
 * @author Gabriel Barbier
 * 
 */
@SuppressWarnings("serial")
public class Princ {

	// Main and demo methods

	public static void main(String[] args) {
		UILib.setPlatformLookAndFeel();

		// create graphview
		String datafile = null;
		String label = "label";
		if (args.length > 1) {
			datafile = args[0];
			label = args[1];
		}

		JFrame frame = demo(datafile, label);
		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}

	public static JFrame demo() {
		return demo((String) null, "label");
	}

	public static JFrame demo(String datafile, String labelParam) {
		Graph g = null;
		String label = labelParam;
		if (datafile == null) {
			g = GraphLib.getGrid(15, 15);
			label = "label";
		} else {
			try {
				g = new GraphMLReader().readGraph(datafile);
			} catch (Exception e) {
				e.printStackTrace();
				System.exit(1);
			}
		}
		return demo(g, label);
	}

	public static JFrame demo(Graph g, String label) {
		final GraphView view = new GraphView(g, label);
		
		// set up menu
		JMenu dataMenu = new JMenu("Data");
		dataMenu.add(new OpenGraphAction(view));
		dataMenu.add(new GraphMenuAction("Grid", "ctrl 1", view) {
			protected Graph getGraph() {
				return GraphLib.getGrid(15, 15);
			}
		});
		dataMenu.add(new GraphMenuAction("Clique", "ctrl 2", view) {
			protected Graph getGraph() {
				return GraphLib.getClique(10);
			}
		});
		dataMenu.add(new GraphMenuAction("Honeycomb", "ctrl 3", view) {
			protected Graph getGraph() {
				return GraphLib.getHoneycomb(5);
			}
		});
		dataMenu.add(new GraphMenuAction("Balanced Tree", "ctrl 4", view) {
			protected Graph getGraph() {
				return GraphLib.getBalancedTree(3, 5);
			}
		});
		dataMenu.add(new GraphMenuAction("Diamond Tree", "ctrl 5", view) {
			protected Graph getGraph() {
				return GraphLib.getDiamondTree(3, 3, 3);
			}
		});
		JMenuBar menubar = new JMenuBar();
		menubar.add(dataMenu);

		// launch window
		JFrame frame = new JFrame("p r e f u s e  |  g r a p h v i e w");
		frame.setJMenuBar(menubar);
		frame.setContentPane(view);
		frame.pack();
		frame.setVisible(true);

		frame.addWindowListener(new WindowAdapter() {
			public void windowActivated(WindowEvent e) {
				view.getVisualization().run("layout");
			}

			public void windowDeactivated(WindowEvent e) {
				view.getVisualization().cancel("layout");
			}
		});

		return frame;
	}
}
