package org.eclipse.modisco.prefuse.examples.treeview;

import prefuse.Visualization;
import prefuse.action.assignment.ColorAction;
import prefuse.util.ColorLib;
import prefuse.visual.VisualItem;

public class NodeColorAction extends ColorAction {

	public NodeColorAction(String group) {
		super(group, VisualItem.FILLCOLOR);
	}

	public int getColor(VisualItem item) {
		if (this.m_vis.isInGroup(item, Visualization.SEARCH_ITEMS))
			return ColorLib.rgb(255, 190, 190);
		else if (this.m_vis.isInGroup(item, Visualization.FOCUS_ITEMS))
			return ColorLib.rgb(198, 229, 229);
		else if (item.getDOI() > -1)
			return ColorLib.rgb(164, 193, 193);
		else
			return ColorLib.rgba(255, 255, 255, 0);
	}

}
