package prefuse.data.util;

import java.util.concurrent.CopyOnWriteArrayList;

import prefuse.data.event.ProjectionListener;

/**
 * Abstract base class for column projection instances. Implements the
 * listener functionality.
 * 
 * @author <a href="http://jheer.org">jeffrey heer</a>
 */
public abstract class AbstractColumnProjection implements ColumnProjection {

    // ------------------------------------------------------------------------
    // Listener Methods
    
    private CopyOnWriteArrayList<ProjectionListener> m_listeners;
    
    /**
     * @see prefuse.data.util.ColumnProjection#addProjectionListener(prefuse.data.event.ProjectionListener)
     */
    public void addProjectionListener(ProjectionListener lstnr) {
        if ( this.m_listeners == null )
            this.m_listeners = new CopyOnWriteArrayList<ProjectionListener>();
        if ( !this.m_listeners.contains(lstnr) )
            this.m_listeners.add(lstnr);
    }

    /**
     * @see prefuse.data.util.ColumnProjection#removeProjectionListener(prefuse.data.event.ProjectionListener)
     */
    public void removeProjectionListener(ProjectionListener lstnr) {
        if ( this.m_listeners != null )
            this.m_listeners.remove(lstnr);
        if ( this.m_listeners.size() == 0 )
            this.m_listeners = null;
    }
    
    public void fireUpdate() {
        if ( this.m_listeners == null )
            return;
        Object[] lstnrs = this.m_listeners.toArray();
        for ( int i=0; i<lstnrs.length; ++i ) {
            ((ProjectionListener)lstnrs[i]).projectionChanged(this);
        }
    }
    
} // end of abstract class AbstractColumnProjection
