package prefuse.util.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;

/**
 * Iterator implementation that combines the results of multiple iterators.
 * 
 * @author <a href="http://jheer.org">jeffrey heer</a>
 */
public class CompositeIterator<E> implements Iterator<E> {

    private Iterator<E>[] m_iters;
    private int m_cur;
    
    @SuppressWarnings("unchecked")
	public CompositeIterator(int size) {
        this.m_iters = new Iterator[size];
    }
    
    @SuppressWarnings("unchecked")
	public CompositeIterator(Iterator<E> iter1, Iterator<E> iter2) {
        this(new Iterator[] {iter1, iter2});
    }
    
    public CompositeIterator(Iterator<E>[] iters) {
        this.m_iters = iters;
        this.m_cur = 0;
    }

    public void setIterator(int idx, Iterator<E> iter) {
        this.m_iters[idx] = iter;
    }
    
    /**
     * Not supported.
     * @see java.util.Iterator#remove()
     */
    public void remove() {
        throw new UnsupportedOperationException();
    }
    
    /**
     * @see java.util.Iterator#next()
     */
    public E next() {
        if ( hasNext() ) {
            return this.m_iters[this.m_cur].next();
        } else {
            throw new NoSuchElementException();
        }
    }

    /**
     * @see java.util.Iterator#hasNext()
     */
    public boolean hasNext() {
        if ( this.m_iters == null )
            return false;
        
        while ( true ) {
            if ( this.m_cur >= this.m_iters.length ) {
                this.m_iters = null;
                return false;
            } if ( this.m_iters[this.m_cur] == null ) {
                ++this.m_cur;
            } else if ( this.m_iters[this.m_cur].hasNext() ) {
                return true;
            } else {
                ++this.m_cur;
            }
        }
    }

} // end of class CompositeIterator
