package prefuse.util.force;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

import prefuse.util.ui.JForcePanel;


/**
 * Swing Action components that brings up a dialog allowing users to configure
 * a force simulation.
 *
 * @author <a href="http://jheer.org">jeffrey heer</a>
 * @see prefuse.util.ui.JForcePanel
 */
public class ForceConfigAction extends AbstractAction {

    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	private JDialog dialog;
    
    /**
     * Create a new ForceConfigAction.
     * @param frame the parent frame for which to create the dialog
     * @param fsim the force simulator to configure
     */
    public ForceConfigAction(JFrame frame, ForceSimulator fsim) {
        this.dialog = new JDialog(frame, false);
        this.dialog.setTitle("Configure Force Simulator");
        JPanel forcePanel = new JForcePanel(fsim);
        this.dialog.getContentPane().add(forcePanel);
        this.dialog.pack();
    }
    
    /**
     * @see java.awt.event.ActionListener#actionPerformed(java.awt.event.ActionEvent)
     */
    public void actionPerformed(ActionEvent e) {
        this.dialog.setVisible(true);
    }

} // end of class ForceConfigAction
