/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.prefuse.examples.graphview;

import java.awt.Color;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.assignment.ColorAction;
import prefuse.action.layout.graph.RadialTreeLayout;
import prefuse.controls.DragControl;
import prefuse.controls.FocusControl;
import prefuse.controls.NeighborHighlightControl;
import prefuse.controls.PanControl;
import prefuse.controls.WheelZoomControl;
import prefuse.controls.ZoomControl;
import prefuse.controls.ZoomToFitControl;
import prefuse.data.Graph;
import prefuse.data.Tuple;
import prefuse.data.event.TupleSetListener;
import prefuse.data.tuple.TupleSet;
import prefuse.render.DefaultRendererFactory;
import prefuse.render.LabelRenderer;
import prefuse.util.ColorLib;
import prefuse.visual.VisualGraph;
import prefuse.visual.VisualItem;

public class GraphView
extends Display {
    public GraphView(Graph g, String label) {
        super(new Visualization());
        LabelRenderer tr = new LabelRenderer();
        tr.setRoundedCorner(8, 8);
        this.m_vis.setRendererFactory(new DefaultRendererFactory(tr));
        this.setGraph(g, label);
        TupleSet focusGroup = this.m_vis.getGroup(Visualization.FOCUS_ITEMS);
        focusGroup.addTupleSetListener(new TupleSetListener(){

            public void tupleSetChanged(TupleSet ts, Tuple[] add, Tuple[] rem) {
                try {
                    int i = 0;
                    while (i < rem.length) {
                        ((VisualItem)rem[i]).setFixed(false);
                        ++i;
                    }
                    i = 0;
                    while (i < add.length) {
                        ((VisualItem)add[i]).setFixed(false);
                        ((VisualItem)add[i]).setFixed(true);
                        ++i;
                    }
                    if (ts.getTupleCount() == 0) {
                        ts.addTuple(rem[0]);
                        ((VisualItem)rem[0]).setFixed(false);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                GraphView.this.m_vis.run("draw");
            }
        });
        ColorAction fill = new ColorAction("graph.nodes", VisualItem.FILLCOLOR, ColorLib.rgb(200, 200, 255));
        fill.add(VisualItem.FIXED, ColorLib.rgb(255, 100, 100));
        fill.add(VisualItem.HIGHLIGHT, ColorLib.rgb(255, 200, 125));
        ActionList draw = new ActionList();
        draw.add(fill);
        draw.add(new ColorAction("graph.nodes", VisualItem.STROKECOLOR, 0));
        draw.add(new ColorAction("graph.nodes", VisualItem.TEXTCOLOR, ColorLib.rgb(0, 0, 0)));
        draw.add(new ColorAction("graph.edges", VisualItem.FILLCOLOR, ColorLib.gray(200)));
        draw.add(new ColorAction("graph.edges", VisualItem.STROKECOLOR, ColorLib.gray(200)));
        RadialTreeLayout treeLayout = new RadialTreeLayout("graph");
        this.m_vis.putAction("treeLayout", treeLayout);
        ActionList animate = new ActionList(-1L);
        animate.add(treeLayout);
        animate.add(fill);
        animate.add(new RepaintAction());
        this.m_vis.putAction("draw", draw);
        this.m_vis.putAction("layout", animate);
        this.m_vis.runAfter("draw", "layout");
        this.setSize(700, 700);
        this.pan(350.0, 350.0);
        this.setForeground(Color.GRAY);
        this.setBackground(Color.WHITE);
        this.addControlListener(new FocusControl(1));
        this.addControlListener(new DragControl());
        this.addControlListener(new PanControl());
        this.addControlListener(new ZoomControl());
        this.addControlListener(new WheelZoomControl());
        this.addControlListener(new ZoomToFitControl());
        this.addControlListener(new NeighborHighlightControl());
        this.setForeground(Color.GRAY);
        this.setBackground(Color.WHITE);
        this.m_vis.run("draw");
    }

    public void setGraph(Graph g, String label) {
        DefaultRendererFactory drf = (DefaultRendererFactory)this.m_vis.getRendererFactory();
        ((LabelRenderer)drf.getDefaultRenderer()).setTextField(label);
        this.m_vis.removeGroup("graph");
        VisualGraph vg = this.m_vis.addGraph("graph", g);
        this.m_vis.setValue("graph.edges", null, VisualItem.INTERACTIVE, Boolean.FALSE);
        VisualItem f = (VisualItem)((Object)vg.getNode(0));
        this.m_vis.getGroup(Visualization.FOCUS_ITEMS).setTuple(f);
        f.setFixed(false);
    }
}

