/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.prefuse.examples.graphview;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import org.eclipse.modisco.prefuse.examples.graphview.GraphMenuAction;
import org.eclipse.modisco.prefuse.examples.graphview.GraphView;
import org.eclipse.modisco.prefuse.examples.graphview.OpenGraphAction;
import prefuse.data.Graph;
import prefuse.data.io.GraphMLReader;
import prefuse.util.GraphLib;
import prefuse.util.ui.UILib;

public class Princ {
    public static void main(String[] args) {
        UILib.setPlatformLookAndFeel();
        String datafile = null;
        String label = "label";
        if (args.length > 1) {
            datafile = args[0];
            label = args[1];
        }
        JFrame frame = Princ.demo(datafile, label);
        frame.setDefaultCloseOperation(3);
    }

    public static JFrame demo() {
        return Princ.demo(null, "label");
    }

    public static JFrame demo(String datafile, String labelParam) {
        Graph g = null;
        String label = labelParam;
        if (datafile == null) {
            g = GraphLib.getGrid(15, 15);
            label = "label";
        } else {
            try {
                g = new GraphMLReader().readGraph(datafile);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        return Princ.demo(g, label);
    }

    public static JFrame demo(Graph g, String label) {
        final GraphView view = new GraphView(g, label);
        JMenu dataMenu = new JMenu("Data");
        dataMenu.add(new OpenGraphAction(view));
        dataMenu.add(new GraphMenuAction("Grid", "ctrl 1", view){

            protected Graph getGraph() {
                return GraphLib.getGrid(15, 15);
            }
        });
        dataMenu.add(new GraphMenuAction("Clique", "ctrl 2", view){

            protected Graph getGraph() {
                return GraphLib.getClique(10);
            }
        });
        dataMenu.add(new GraphMenuAction("Honeycomb", "ctrl 3", view){

            protected Graph getGraph() {
                return GraphLib.getHoneycomb(5);
            }
        });
        dataMenu.add(new GraphMenuAction("Balanced Tree", "ctrl 4", view){

            protected Graph getGraph() {
                return GraphLib.getBalancedTree(3, 5);
            }
        });
        dataMenu.add(new GraphMenuAction("Diamond Tree", "ctrl 5", view){

            protected Graph getGraph() {
                return GraphLib.getDiamondTree(3, 3, 3);
            }
        });
        JMenuBar menubar = new JMenuBar();
        menubar.add(dataMenu);
        JFrame frame = new JFrame("p r e f u s e  |  g r a p h v i e w");
        frame.setJMenuBar(menubar);
        frame.setContentPane(view);
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent e) {
                view.getVisualization().run("layout");
            }

            public void windowDeactivated(WindowEvent e) {
                view.getVisualization().cancel("layout");
            }
        });
        return frame;
    }
}

