/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.prefuse.examples.radialgraphview;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.eclipse.modisco.prefuse.examples.radialgraphview.RadialGraphView;
import prefuse.Visualization;
import prefuse.controls.ControlAdapter;
import prefuse.data.Graph;
import prefuse.data.Table;
import prefuse.data.io.GraphMLReader;
import prefuse.data.query.SearchQueryBinding;
import prefuse.data.search.SearchTupleSet;
import prefuse.util.FontLib;
import prefuse.util.ui.JFastLabel;
import prefuse.util.ui.JSearchPanel;
import prefuse.util.ui.UILib;
import prefuse.visual.VisualItem;

public class Princ {
    public static final String DATA_FILE = "/socialnet.xml";

    public static void main(String[] argv) {
        String infile = DATA_FILE;
        String label = "name";
        if (argv.length > 1) {
            infile = argv[0];
            label = argv[1];
        }
        UILib.setPlatformLookAndFeel();
        JFrame frame = new JFrame("p r e f u s e  |  r a d i a l g r a p h v i e w");
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(Princ.demo(infile, label));
        frame.pack();
        frame.setVisible(true);
    }

    public static JPanel demo() {
        return Princ.demo(DATA_FILE, "name");
    }

    public static JPanel demo(String datafile, String label) {
        Graph g = null;
        try {
            g = new GraphMLReader().readGraph(datafile);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return Princ.demo(g, label);
    }

    public static JPanel demo(Graph g, final String label) {
        RadialGraphView gview = new RadialGraphView(g, label);
        Visualization vis = gview.getVisualization();
        SearchQueryBinding sq = new SearchQueryBinding((Table)vis.getGroup("tree.nodes"), label, (SearchTupleSet)vis.getGroup(Visualization.SEARCH_ITEMS));
        JSearchPanel search = sq.createSearchPanel();
        search.setShowResultCount(true);
        search.setBorder(BorderFactory.createEmptyBorder(5, 5, 4, 0));
        search.setFont(FontLib.getFont("Tahoma", 0, 11));
        final JFastLabel title = new JFastLabel("                 ");
        title.setPreferredSize(new Dimension(350, 20));
        title.setVerticalAlignment(3);
        title.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        title.setFont(FontLib.getFont("Tahoma", 0, 16));
        gview.addControlListener(new ControlAdapter(){

            public void itemEntered(VisualItem item, MouseEvent e) {
                if (item.canGetString(label)) {
                    title.setText(item.getString(label));
                }
            }

            public void itemExited(VisualItem item, MouseEvent e) {
                title.setText(null);
            }
        });
        Box box = new Box(0);
        box.add(Box.createHorizontalStrut(10));
        box.add(title);
        box.add(Box.createHorizontalGlue());
        box.add(search);
        box.add(Box.createHorizontalStrut(3));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)gview, "Center");
        panel.add((Component)box, "South");
        Color BACKGROUND = Color.WHITE;
        Color FOREGROUND = Color.DARK_GRAY;
        UILib.setColor(panel, BACKGROUND, FOREGROUND);
        return panel;
    }
}

